/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Gui;
import com.klikli_dev.modonomicon.book.PatchouliLink;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import org.commonmark.node.Link;
import org.commonmark.node.Node;

import java.util.function.Consumer;
import net.minecraft.class_2558;
import net.minecraft.class_2558.class_2559;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class PatchouliLinkRenderer implements LinkRenderer {

    @Override
    public boolean visit(Link link, Consumer<Node> visitChildren, ComponentNodeRendererContext context) {
        if (PatchouliLink.isPatchouliLink(link.getDestination())) {

            var currentColor = context.getCurrentStyle().method_10973();

            BookErrorManager.get().setContext("Link: {}, \n{}",
                    link.getDestination(),
                    BookErrorManager.get().getContextHelper()
            );

            var patchoulLink = PatchouliLink.from(link.getDestination());

            var goToText = "patchouli."
                    + patchoulLink.bookId.toString().replace(":", ".").replace("/", ".")
                    + "."
                    + patchoulLink.entryId.method_12832().replace(":", ".").replace("/", ".")
                    + ".name";
            //e.g. patchouli.occultism.dictionary_of_spirits.misc.books_of_calling.name

            //Note: if we ever change this we need to adjust renderComponentHoverEffect
            var hoverComponent = class_2561.method_43469(Gui.HOVER_BOOK_LINK, class_2561.method_43471(goToText));


            //if we have a color we use it, otherwise we use link default.
            context.setCurrentStyle(context.getCurrentStyle()
                    .method_27703(currentColor == null ? context.getLinkColor() : currentColor)
                    .method_10958(new class_2558(class_2559.field_11748, link.getDestination()))
                    .method_10949(new class_2568(class_2568.class_5247.field_24342, hoverComponent))
            );

            visitChildren.accept(link);

            //links are not style instructions, so we reset to our previous color.
            context.setCurrentStyle(context.getCurrentStyle()
                    .method_27703(currentColor)
                    .method_10958(null)
                    .method_10949(null)
            );

            BookErrorManager.get().setContext(null);
            return true;
        }
        return false;

    }
}
