/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.render.page;

import I;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock.SimulateResult;
import com.klikli_dev.modonomicon.book.page.BookMultiblockPage;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookContentRenderer;
import com.klikli_dev.modonomicon.client.gui.book.button.VisualizeButton;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

import java.util.*;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4597.class_4598;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class BookMultiblockPageRenderer extends BookPageRenderer<BookMultiblockPage> implements PageWithTextRenderer {

    private static final class_5819 randomSource = class_5819.method_43053();
    private final Map<class_2338, class_2586> blockEntityCache = new Object2ObjectOpenHashMap<>();
    private final Set<class_2586> erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap<>());

    protected Pair<class_2338, Collection<SimulateResult>> multiblockSimulation;
    protected class_4185 visualizeButton;

    public BookMultiblockPageRenderer(BookMultiblockPage page) {
        super(page);
    }

    public void handleButtonVisualize(class_4185 button) {
        MultiblockPreviewRenderer.setMultiblock(this.page.getMultiblock(), this.page.getMultiblockName().getComponent(), true);
        BookGuiManager.get().closeScreenStack(this.parentScreen); //will cause the book to close entirely, and save the open page

        //TODO: visualizer bookmark to go back to this page quickly?
        //String entryKey =  this.parentEntry.getId().toString(); will be used for bookmark for multiblock
//        Bookmark bookmark = new Bookmark(entryKey, pageNum / 2);
//        parent.addBookmarkButtons();
    }

    private void renderMultiblock(class_332 guiGraphics) {
        var mc = class_310.method_1551();
        var level = mc.field_1687;

        var pos = class_2338.field_10980;
        var facingRotation = class_2470.field_11467;

        this.page.getMultiblock().setLevel(level);

        if (this.page.getMultiblock().isSymmetrical()) {
            facingRotation = class_2470.field_11467;
        }

        class_2382 size = this.page.getMultiblock().getSize();
        int sizeX = size.method_10263();
        int sizeY = size.method_10264();
        int sizeZ = size.method_10260();
        float maxX = 90;
        float maxY = 90;
        float diag = (float) Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / sizeY;
        float scale = -Math.min(scaleX, scaleY);

        int xPos = BookEntryScreen.PAGE_WIDTH / 2;
        int yPos = 60;

        guiGraphics.method_51448().method_22903();

        guiGraphics.method_51448().method_46416(xPos, yPos, 100);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_51448().method_46416(-(float) sizeX / 2, -(float) sizeY / 2, 0);


        // Initial eye pos somewhere off in the distance in the -Z direction
        Vector4f eye = new Vector4f(0, 0, -100, 1);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();

        // For each GL rotation done, track the opposite to keep the eye pos accurate
        guiGraphics.method_51448().method_22907(class_7833.field_40714.rotationDegrees(-30F));
        rotMat.rotate(class_7833.field_40714.rotationDegrees(30));

        float offX = (float) -sizeX / 2;
        float offZ = (float) -sizeZ / 2 + 1;

        float time = this.parentScreen.getTicksInBook() * 0.5F;
        if (!class_437.method_25442()) {
            time += ClientTicks.partialTicks;
        }
        guiGraphics.method_51448().method_46416(-offX, 0, -offZ);
        guiGraphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(time));
        rotMat.rotate(class_7833.field_40716.rotationDegrees(-time));
        guiGraphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(45));
        rotMat.rotate(class_7833.field_40716.rotationDegrees(-45));
        guiGraphics.method_51448().method_46416(offX, 0, offZ);

        // Finally apply the rotations
        rotMat.transform(eye);
        eye.div(eye.w);


        var buffers = mc.method_22940().method_23000();

        class_2338 checkPos = null;
        if (mc.field_1765 instanceof class_3965 blockRes) {
            checkPos = blockRes.method_17777().method_10093(blockRes.method_17780());
        }

        guiGraphics.method_51448().method_22903();
        RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
        guiGraphics.method_51448().method_46416(0, 0, -1);

        for (Multiblock.SimulateResult r : this.multiblockSimulation.getSecond()) {
            float alpha = 0.3F;
            if (r.getWorldPosition().equals(checkPos)) {
                alpha = 0.6F + (float) (Math.sin(ClientTicks.total * 0.3F) + 1F) * 0.1F;
            }

            class_2680 renderState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).method_26186(facingRotation);

            this.renderBlock(buffers, level, renderState, r.getWorldPosition(), alpha, guiGraphics.method_51448());

            if (renderState.method_26204() instanceof class_2343 eb) {
                //if our cached be is not compatible with the render state, remove it.
                //this happens e.g. if there is a blocktag that contains multible blocks with different BEs
                var be = this.blockEntityCache.compute(r.getWorldPosition().method_10062(), (p, cachedBe) -> {
                    if (cachedBe != null && !cachedBe.method_11017().method_20526(renderState)) {
                        return eb.method_10123(p, renderState);
                    }
                    return cachedBe != null ? cachedBe : eb.method_10123(p, renderState);
                });

                if (be != null && !this.erroredBlockEntities.contains(be)) {
                    be.method_31662(mc.field_1687);

                    // fake cached state in case the renderer checks it as we don't want to query the actual world
                    //noinspection deprecation
                    be.method_31664(renderState);

                    guiGraphics.method_51448().method_22903();
                    var bePos = r.getWorldPosition();
                    guiGraphics.method_51448().method_46416(bePos.method_10263(), bePos.method_10264(), bePos.method_10260());

                    try {
                        class_827<class_2586> renderer = class_310.method_1551().method_31975().method_3550(be);
                        if (renderer != null) {
                            renderer.method_3569(be, ClientTicks.partialTicks, guiGraphics.method_51448(), buffers, 0xF000F0, class_4608.field_21444);
                        }
                    } catch (Exception e) {
                        this.erroredBlockEntities.add(be);
                        Modonomicon.LOG.error("Error rendering block entity", e);
                    }
                    guiGraphics.method_51448().method_22909();
                }
            }
        }
        guiGraphics.method_51448().method_22909();
        buffers.method_22993();
        guiGraphics.method_51448().method_22909();

    }

    private void renderBlock(class_4597.class_4598 buffers, class_638 level, class_2680 state, class_2338 pos, float alpha, class_4587 ps) {
        if (pos != null) {
            ps.method_22903();
            ps.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());

            ClientServices.MULTIBLOCK.renderBlock(state, pos, this.page.getMultiblock(), ps, buffers, randomSource);

            ps.method_22909();
        }
    }

    @Override
    public int getTextY() {
        //text is always below multiblock, and we don't shift based on multiblock name (unlike title for text pages)
        return 115;
    }

    @Override
    public void onBeginDisplayPage(BookEntryScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);

        this.multiblockSimulation = this.page.getMultiblock().simulate(null, class_2338.field_10980, class_2470.field_11467, true, true);

        if (this.page.showVisualizeButton()) {
            this.addButton(this.visualizeButton = new VisualizeButton(this.parentScreen, 13, 102, this::handleButtonVisualize));
        }
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float ticks) {

        //render a frame for the multiblock render area
        int x = BookEntryScreen.PAGE_WIDTH / 2 - 53;
        int y = 7;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
        BookContentRenderer.drawFromContentTexture(guiGraphics, this.page.getBook(), x, y, 405, 149, 106, 106);

        //render multiblock name in place of title
        if (!this.page.getMultiblockName().isEmpty()) {
            this.renderTitle(guiGraphics, this.page.getMultiblockName(), false, BookEntryScreen.PAGE_WIDTH / 2, 0);
        }

        this.renderMultiblock(guiGraphics);

        var textY = this.getTextY();
        this.renderBookTextHolder(guiGraphics, this.page.getText(), 0, textY, BookEntryScreen.PAGE_WIDTH, BookEntryScreen.PAGE_HEIGHT - textY);

        //TODO: render button to show multiblock in world
        //            //TODO: show multiblock preview on button click
//            var block = MultiblockDataManager.get().getMultiblock(ResourceLocation.tryParse("modonomicon:blockentity"));
//            MultiblockPreviewRenderer.setMultiblock(block, Component.translatable("multiblock.modonomicon.test"), true);

        var style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null)
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
    }

    @Nullable
    @Override
    public class_2583 getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0 && pMouseY > 0) {
            var multiblockNameStyle = this.getClickedComponentStyleAtForTitle(this.page.getMultiblockName(), BookEntryScreen.PAGE_WIDTH / 2, 0, pMouseX, pMouseY);
            if (multiblockNameStyle != null) {
                return multiblockNameStyle;
            }

            var x = this.parentScreen.getBook().getBookTextOffsetX();
            var y = this.getTextY() + this.parentScreen.getBook().getBookTextOffsetY();
            var width = BookEntryScreen.PAGE_WIDTH + this.parentScreen.getBook().getBookTextOffsetWidth() - x; //always remove the offset x from the width to avoid overflow
            var height = BookEntryScreen.PAGE_HEIGHT + this.parentScreen.getBook().getBookTextOffsetHeight() - y; //always remove the offset y from the height to avoid overflow

            var textStyle = this.getClickedComponentStyleAtForTextHolder(this.page.getText(), x, y, width, height, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }


}
