/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.data;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.page.BookPage;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

public interface BookPageJsonLoader<T extends BookPage> extends JsonLoader<T> {
    T fromJson(class_2960 entryId, JsonObject json, class_7225.class_7874 provider);

    /**
     * Deserializes the model from json.
     * @deprecated use {@link #fromJson(class_2960, JsonObject, class_7225.class_7874)} instead.
     */
    @Override
    @Deprecated(forRemoval = true, since="1.21.1-1.105.0")
    default T fromJson(JsonObject json, class_7225.class_7874 provider){
        //TODO(BookPageLoading): replace jsonloader with bookpageloader entirely when removing this
        throw new UnsupportedOperationException("BookPageJsonLoaders must implement fromJson(ResourceLocation, JsonObject, HolderLookup.Provider)");
    }
}
