// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.datagen.book.demo.features;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.modonomicon.platform.Services;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import java.util.List;

public class EntryWithComponentIcon extends EntryProvider {
    public static final String ID = "component_icon";

    public EntryWithComponentIcon(CategoryProvider parent) {
        super(parent);
    }

    @Override
    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create()
                .withTitle(this.context().pageTitle())
                .withText(this.context().pageText())
        );
        this.pageTitle("Component Item Icon Entry");
        this.pageText("""
                This entry has an icon that is an ItemStack with a data component.
                """
        );
    }

    @Override
    protected String entryName() {
        return "Component Item Icon Entry";
    }

    @Override
    protected String entryDescription() {
        return "An entry showcasing item stack icons with data components";
    }

    @Override
    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    @Override
    protected BookIconModel entryIcon() {
        var iconStack = new class_1799(class_1802.field_8267);
        iconStack.method_57379(class_9334.field_49644, new class_9282(0x169C9C, false));
        return BookIconModel.create(iconStack);
    }

    @Override
    protected BookEntryModel additionalSetup(BookEntryModel entry) {
        return super.additionalSetup(entry);
    }

    @Override
    protected String entryId() {
        return ID;
    }
}
