// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.datagen.book.demo.features;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_7924;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class SpotlightEntry extends EntryProvider {
    public static final String ID = "spotlight";

    public SpotlightEntry(CategoryProvider parent) {
        super(parent);
    }

    @Override
    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create()
                .withTitle(this.context().pageTitle())
                .withText(this.context().pageText())
        );
        this.pageTitle("Spotlight Entry");
        this.pageText("""
                Spotlight pages allow to show items (actually, ingredients).
                """
        );

        this.page("spotlight1", () -> BookSpotlightPageModel.create()
                .withTitle(this.context().pageTitle())
                .withText(this.context().pageText())
                .withItem(class_1856.method_8091(class_1802.field_8279))
        );
        this.pageTitle("Custom Title");
        this.pageText("""
                A sample spotlight page with custom title.\\
                It shows how an {0} can be rendered with a little border and fancyness around it.\\
                I am adding this link to see if spotlight pages have an offset problem. \\
                The entry needs to be longer to trigger scaling.\\
                Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed sed odio eu dolor ornare tempor. In nibh erat, finibus sed eros id, finibus interdum justo. Aenean luctus, magna at pharetra accumsan, tellus libero tincidunt enim, id varius ante sem sit amet ipsum.\s
                """,
                this.itemLink(class_1802.field_8279)
        );

        this.page("spotlight2", () -> BookSpotlightPageModel.create()
                .withText(this.context().pageText())
                .withItem(class_1856.method_8091(class_1802.field_8477))
        );
        this.pageText("A sample spotlight page with automatic title.");

        var iconStack = new class_1799(class_1802.field_8267);
        iconStack.method_57379(class_9334.field_49644, new class_9282(0x169C9C, false));
        this.page("spotlight3", () -> BookSpotlightPageModel.create()
                .withText(this.context().pageText())
                .withItem(iconStack)
        );
        this.pageText("A sample spotlight page with an item with components");

        this.page("spotlight4", () -> BookSpotlightPageModel.create()
                .withText(this.context().pageText())
                //We are using the potion registry here to test and demonstrate using this.registries(). Vanilla potions can be accessed directly without using the resource key, as the Potions class offers potion holders.
                .withItem(class_1844.method_57400(class_1802.field_8574, this.registries().method_46762(class_7924.field_41215).method_46747(class_1847.field_8963.method_40230().get())))
        );
        this.pageText("A sample spotlight page with a potion");
    }

    @Override
    protected String entryName() {
        return "Spotlight Entry";
    }

    @Override
    protected String entryDescription() {
        return "An entry showcasing spotlight pages.";
    }

    @Override
    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    @Override
    protected BookIconModel entryIcon() {
        return BookIconModel.create(class_1802.field_8668);
    }

    @Override
    protected String entryId() {
        return ID;
    }
}
