/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class AddBookmarkMessage implements Message {

    public static final class_9154<AddBookmarkMessage> TYPE = new class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "add_bookmark"));

    public static final class_9139<class_9129, AddBookmarkMessage> STREAM_CODEC = class_9139.method_56434(
            BookAddress.STREAM_CODEC,
            (m) -> m.address,
            AddBookmarkMessage::new
    );


    public BookAddress address;

    public AddBookmarkMessage(BookAddress address) {
        this.address = address;
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var book = BookDataManager.get().getBook(this.address.bookId());
        if(BookVisualStateManager.get().getBookmarksFor(player, book).stream().noneMatch(e -> e.entryId().equals(this.address.entryId()))){
            BookVisualStateManager.get().addBookmarkFor(player, book, this.address);
        }
        BookVisualStateManager.get().syncFor(player);
    }
}
