/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_8779;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class RequestAdvancementMessage implements Message {

    public static final class_9154<RequestAdvancementMessage> TYPE = new class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "request_advancement"));

    public static final class_9139<class_9129, RequestAdvancementMessage> STREAM_CODEC = class_9139.method_56434(
            class_2960.field_48267,
            (m) -> m.advancementId,
            RequestAdvancementMessage::new
    );

    public class_2960 advancementId;

    public RequestAdvancementMessage(class_2960 advancementId) {
        this.advancementId = advancementId;
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var adv = minecraftServer.method_3851().method_12896(this.advancementId);

        if (adv != null) {
            Services.NETWORK.sendTo(player, new SendAdvancementToClientMessage(adv));
        } else {
            Modonomicon.LOG.warn("Requested Advancement {} from server, but not found", this.advancementId);
        }
    }
}
