/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class RequestSyncBookStatesMessage implements Message {

    public static final RequestSyncBookStatesMessage INSTANCE = new RequestSyncBookStatesMessage();

    public static final class_9154<RequestSyncBookStatesMessage> TYPE = new class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "request_sync_book_states"));

    public static final class_9139<class_9129, RequestSyncBookStatesMessage> STREAM_CODEC = class_9139.method_56431(INSTANCE);


    private RequestSyncBookStatesMessage() {
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        BookUnlockStateManager.get().syncFor(player);
        BookVisualStateManager.get().syncFor(player);
    }
}
