/*
 * SPDX-FileCopyrightText: 2023 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.registry;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.data.BookDataManager;
import java.util.Set;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7708;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CreativeModeTabRegistry {

    public static final class_5321<class_1761> MODONOMICON_TAB_KEY = class_5321.method_29179(class_7924.field_44688, Modonomicon.loc(Modonomicon.MOD_ID));
    public static final class_1761 MODONOMICON = FabricItemGroup.builder()
            .method_47320(() -> ItemRegistry.MODONOMICON_PURPLE.get().method_7854())
            .method_47321(class_2561.method_43471(ModonomiconConstants.I18n.ITEM_GROUP))
            .method_47324();

    public static void onModifyEntries(class_1761 group, FabricItemGroupEntries entries) {
        var tabKey = class_7923.field_44687.method_29113(group).get();

        //From: Neo EventHooks#onCreativeModeTabBuildContents
        //we need to use it here to test before inserting, because event.getEntries().contains uses a different hashing strategy and is thus not reliable
        final var searchDupes = class_7708.method_47572();

        BookDataManager.get().getBooks().values().forEach(b -> {
            if (tabKey == class_7706.field_40200 ||
                    MODONOMICON == group ||
                    class_7923.field_44687.method_10223(class_2960.method_60654(b.getCreativeTab())) == group) {
                if (b.generateBookItem()) {
                    class_1799 stack = new class_1799(ItemRegistry.MODONOMICON.get());

                    stack.method_57379(DataComponentRegistry.BOOK_ID.get(), b.getId());

                    if (searchDupes.add(stack))
                        entries.method_45417(stack, tabKey == class_7706.field_40200 ? class_1761.class_7705.field_40193 : class_1761.class_7705.field_40191);
                }
            }
        });
    }

}
