/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.registry;

import com.klikli_dev.modonomicon.Modonomicon;
import java.util.function.UnaryOperator;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import net.minecraft.class_9331;

public class DataComponentRegistry {
    public static final RegistrationProvider<class_9331<?>> DATA_COMPONENTS = RegistrationProvider.get(class_7924.field_49659, Modonomicon.MOD_ID);

    public static final RegistryObject<class_9331<class_2960>> BOOK_ID = register("book_id", builder ->
            builder.method_57881(class_2960.field_25139)
                    .method_57882(class_2960.field_48267).method_59871()
    );

    // Called in the mod initializer / constructor in order to make sure that items are registered
    public static void load() {
    }

    private static <T> RegistryObject<class_9331<T>> register(String name, UnaryOperator<class_9331.class_9332<T>> unaryOperator) {
        return DATA_COMPONENTS.register(name, () -> unaryOperator.apply(class_9331.method_57873()).method_57880());
    }
}
