/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */
package com.klikli_dev.modonomicon.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import net.minecraft.class_2561;
import net.minecraft.class_7225;

public class BookGsonHelper {

    public static BookTextHolder getAsBookTextHolder(JsonObject pJson, String pMemberName, BookTextHolder pFallback, class_7225.class_7874 provider) {
        return pJson.has(pMemberName) ? convertToBookTextHolder(pJson.get(pMemberName), pMemberName, provider) : pFallback;
    }

    public static BookTextHolder convertToBookTextHolder(JsonElement pJson, String pMemberName, class_7225.class_7874 provider) {
        if (pJson.isJsonPrimitive()) {
            return new BookTextHolder(pJson.getAsString());
        } else {
            return new BookTextHolder(class_2561.class_2562.method_10872(pJson, provider));
        }
    }
}
