/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.google.gson.JsonElement;
import com.klikli_dev.modonomicon.api.datagen.BookContextHelper;
import com.klikli_dev.modonomicon.api.datagen.ConditionHelper;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public abstract class BookProvider
implements DataProvider {
    protected static final Logger LOGGER = LogUtils.getLogger();
    public static final Collector<ModonomiconLanguageProvider, ?, Object2ObjectOpenHashMap<String, ModonomiconLanguageProvider>> mapMaker = Collector.of(Object2ObjectOpenHashMap::new, (map, l) -> map.put((Object)l.locale(), l), (m1, m2) -> {
        m1.putAll((Map)m2);
        return m1;
    }, map -> {
        map.trim();
        return map;
    }, Collector.Characteristics.UNORDERED);
    protected final PackOutput packOutput;
    protected final ModonomiconLanguageProvider lang;
    protected final Map<String, ModonomiconLanguageProvider> translations;
    protected final Map<ResourceLocation, BookModel> bookModels;
    protected final String modid;
    protected String bookId;
    protected BookContextHelper context;
    protected Map<String, String> defaultMacros;
    protected ConditionHelper conditionHelper;

    public BookProvider(String bookId, PackOutput packOutput, String modid, ModonomiconLanguageProvider defaultLang, ModonomiconLanguageProvider ... translations) {
        this.modid = modid;
        this.packOutput = packOutput;
        this.lang = defaultLang;
        this.bookModels = new Object2ObjectOpenHashMap();
        this.translations = (Map)Stream.concat(Arrays.stream(translations), Stream.of(defaultLang)).collect(mapMaker);
        this.bookId = bookId;
        this.context = new BookContextHelper(this.modid);
        this.defaultMacros = new Object2ObjectOpenHashMap();
        this.conditionHelper = new ConditionHelper();
    }

    protected ModonomiconLanguageProvider lang() {
        return this.lang;
    }

    protected ModonomiconLanguageProvider lang(String locale) {
        return this.translations.get(locale);
    }

    public String bookId() {
        return this.bookId;
    }

    protected BookContextHelper context() {
        return this.context;
    }

    protected ConditionHelper condition() {
        return this.conditionHelper;
    }

    protected abstract void registerDefaultMacros();

    protected abstract BookModel generateBook();

    protected void registerDefaultMacro(String macro, String value) {
        this.defaultMacros.put(macro, value);
    }

    protected Map<String, String> defaultMacros() {
        return this.defaultMacros;
    }

    protected void generate() {
        this.context.book(this.bookId);
        this.add(this.generateBook());
    }

    protected ResourceLocation modLoc(String name) {
        return new ResourceLocation(this.modid, name);
    }

    protected BookModel add(BookModel bookModel) {
        if (this.bookModels.containsKey(bookModel.getId())) {
            throw new IllegalStateException("Duplicate book " + String.valueOf(bookModel.getId()));
        }
        this.bookModels.put(bookModel.getId(), bookModel);
        return bookModel;
    }

    protected Path getPath(Path dataFolder, BookModel bookModel) {
        ResourceLocation id = bookModel.getId();
        return dataFolder.resolve(id.m_135827_()).resolve("modonomicon/books").resolve(id.m_135815_() + "/book.json");
    }

    protected Path getPath(Path dataFolder, BookCategoryModel bookCategoryModel) {
        ResourceLocation id = bookCategoryModel.getId();
        return dataFolder.resolve(id.m_135827_()).resolve("modonomicon/books").resolve(bookCategoryModel.getBook().getId().m_135815_()).resolve("categories").resolve(id.m_135815_() + ".json");
    }

    protected Path getPath(Path dataFolder, BookCommandModel bookCommandModel) {
        ResourceLocation id = bookCommandModel.getId();
        return dataFolder.resolve(id.m_135827_()).resolve("modonomicon/books").resolve(bookCommandModel.getBook().getId().m_135815_()).resolve("commands").resolve(id.m_135815_() + ".json");
    }

    protected Path getPath(Path dataFolder, BookEntryModel bookEntryModel) {
        ResourceLocation id = bookEntryModel.getId();
        return dataFolder.resolve(id.m_135827_()).resolve("modonomicon/books").resolve(bookEntryModel.getCategory().getBook().getId().m_135815_()).resolve("entries").resolve(id.m_135815_() + ".json");
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        Path dataFolder = this.packOutput.m_247566_(PackOutput.Target.DATA_PACK);
        this.registerDefaultMacros();
        this.generate();
        for (BookModel bookModel : this.bookModels.values()) {
            Path bookPath = this.getPath(dataFolder, bookModel);
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)bookModel.toJson(), (Path)bookPath));
            for (BookCategoryModel bookCategoryModel : bookModel.getCategories()) {
                Path bookCategoryPath = this.getPath(dataFolder, bookCategoryModel);
                futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)bookCategoryModel.toJson(), (Path)bookCategoryPath));
                for (BookEntryModel bookEntryModel : bookCategoryModel.getEntries()) {
                    Path bookEntryPath = this.getPath(dataFolder, bookEntryModel);
                    futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)bookEntryModel.toJson(), (Path)bookEntryPath));
                }
            }
            for (BookCommandModel bookCommandModel : bookModel.getCommands()) {
                Path bookCommandPath = this.getPath(dataFolder, bookCommandModel);
                futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)bookCommandModel.toJson(), (Path)bookCommandPath));
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Books: " + this.modid;
    }
}

