/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.JsonOps;
import net.minecraft.class_2561;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import org.jetbrains.annotations.NotNull;

public class BookTextHolderModel {
    protected class_2561 component;
    protected String string;

    public BookTextHolderModel(class_2561 component) {
        this.component = component;
    }

    public BookTextHolderModel(@NotNull String string) {
        this.string = string;
    }

    public boolean hasComponent() {
        return this.component != null;
    }

    public JsonElement toJson(class_7225.class_7874 provider) {
        if (this.hasComponent()) {
            //From Component.Serializer.serialize as it is private
            return class_8824.field_46597.encodeStart(provider.method_57093(JsonOps.INSTANCE), this.component).getOrThrow(JsonParseException::new);
        }
        return new JsonPrimitive(this.string);
    }

    public class_2561 getComponent() {
        return this.component;
    }

    public String getString() {
        return this.string;
    }
}
