/*
 * SPDX-FileCopyrightText: 2022 Authors of Patchouli
 *
 * SPDX-License-Identifier: MIT
 */
package com.klikli_dev.modonomicon.api.multiblock;

import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

/**
 * A composite element of a rendering block state, and a predicate to validate if the real state in the world is valid
 * or not. Used as the core building block for multiblocks.
 */
public interface StateMatcher {

    /**
     * The state matcher type Id for serialization.
     */
    class_2960 getType();

    /**
     * Gets the state displayed by this state matcher for rendering the multiblock page type and the in-world preview.
     *
     * @param ticks World ticks, to allow cycling the state shown.
     */
    class_2680 getDisplayedState(long ticks);

    /**
     * Returns a predicate that validates whether the given state is acceptable. This should check the passed in
     * blockstate instead of requerying it from the world, for both performance and correctness reasons -- the state may
     * be rotated for multiblock matching.
     */
    TriPredicate<class_1922, class_2338, class_2680> getStatePredicate();

    /**
     * Serializes the state matcher to the given buffer.
     */
    void toNetwork(class_2540 buffer);

    /**
     * If true this state matcher counts towards the total blocks in the multiblock preview display.
     * If false it behaves like air.
     */
    boolean countsTowardsTotalBlocks();

}
