/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants.Data.Page;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class BookImagePage extends BookPage {
    protected BookTextHolder title;
    protected BookTextHolder text;
    protected class_2960[] images;
    protected boolean border;
    protected boolean useLegacyRendering;

    public BookImagePage(BookTextHolder title, BookTextHolder text, class_2960[] images, boolean border, boolean useLegacyRendering, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.title = title;
        this.text = text;
        this.images = images;
        this.border = border;
        this.useLegacyRendering = useLegacyRendering;
    }

    public static BookImagePage fromJson(class_2960 entryId, JsonObject json, class_7225.class_7874 provider) {
        var title = BookGsonHelper.getAsBookTextHolder(json, "title", BookTextHolder.EMPTY, provider);
        var text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY, provider);

        var imagesArray = class_3518.method_15261(json, "images");
        var images = new class_2960[imagesArray.size()];
        for (int i = 0; i < imagesArray.size(); i++) {
            images[i] = class_2960.method_60654(class_3518.method_15287(imagesArray.get(i), "images[" + i + "]"));
        }

        var border = class_3518.method_15258(json, "border", true);
        var useLegacyRendering = class_3518.method_15258(json, "use_legacy_rendering", false);

        var anchor = class_3518.method_15253(json, "anchor", "");
        var condition = json.has("condition")
                ? BookCondition.fromJson(entryId, json.getAsJsonObject("condition"), provider)
                : new BookNoneCondition();
        return new BookImagePage(title, text, images, border, useLegacyRendering, anchor, condition);
    }

    public static BookImagePage fromNetwork(class_9129 buffer) {
        var title = BookTextHolder.fromNetwork(buffer);
        var text = BookTextHolder.fromNetwork(buffer);

        var count = buffer.method_10816();
        var images = new class_2960[count];
        for (int i = 0; i < count; i++) {
            images[i] = class_2960.method_60654(buffer.method_19772());
        }

        var border = buffer.readBoolean();
        var useLegacyRendering = buffer.readBoolean();

        var anchor = buffer.method_19772();
        var condition = BookCondition.fromNetwork(buffer);
        return new BookImagePage(title, text, images, border, useLegacyRendering, anchor, condition);
    }

    public class_2960[] getImages() {
        return this.images;
    }

    public boolean hasBorder() {
        return this.border;
    }

    public boolean useLegacyRendering() {
        return this.useLegacyRendering;
    }

    public BookTextHolder getTitle() {
        return this.title;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    @Override
    public class_2960 getType() {
        return Page.IMAGE;
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);

        if (!this.title.hasComponent()) {
            this.title = new BookTextHolder(class_2561.method_43471(this.title.getKey())
                    .method_27696(class_2583.field_24360
                            .method_10982(true)
                            .method_36139(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        this.title.toNetwork(buffer);
        this.text.toNetwork(buffer);

        buffer.method_10804(this.images.length);
        for (var image : this.images) {
            buffer.method_10814(image.toString());
        }

        buffer.method_52964(this.border);
        buffer.method_52964(this.useLegacyRendering);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query, class_1937 level) {
        return this.title.getString().toLowerCase().contains(query)
                || this.text.getString().toLowerCase().contains(query);
    }
}
