/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.bookstate.visual;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public class BookVisualState {
    public static final Codec<BookVisualState> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codec.unboundedMap(class_2960.field_25139, CategoryVisualState.CODEC).fieldOf("categoryStates").forGetter((state) -> state.categoryStates),
            class_2960.field_25139.optionalFieldOf("openCategory").forGetter((state) -> Optional.ofNullable(state.openCategory)),
            Codec.INT.fieldOf("openPagesIndex").forGetter((state) -> state.openPagesIndex)
    ).apply(instance, BookVisualState::new));

    public Map<class_2960, CategoryVisualState> categoryStates;

    @Nullable
    public class_2960 openCategory;

    /**
     * For books in index mode
     */
    public int openPagesIndex;

    public BookVisualState() {
        this(Object2ObjectMaps.emptyMap(), (class_2960) null, 0);
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    public BookVisualState(Map<class_2960, CategoryVisualState> categoryStates, Optional<class_2960> openCategory, int openPagesIndex) {
        this(categoryStates, openCategory.orElse(null), openPagesIndex);
    }

    public BookVisualState(Map<class_2960, CategoryVisualState> categoryStates, @Nullable class_2960 openCategory, int openPagesIndex) {
        this.categoryStates = new Object2ObjectOpenHashMap<>(categoryStates);
        this.openCategory = openCategory;
        this.openPagesIndex = openPagesIndex;
    }
}
