// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.client;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.client.render.FluidBlockVertexConsumer;
import com.klikli_dev.modonomicon.platform.services.MultiblockHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_765;

public class FabricMultiblockHelper implements MultiblockHelper {
    @Override
    public void renderBlock(class_2680 state, class_2338 pos, Multiblock multiblock, class_4587 ps, class_4597 buffers, class_5819 rand) {
        var blockRenderer = class_310.method_1551().method_1541();

        var fluidState = state.method_26227();
        if (!fluidState.method_15769()) {
            var layer = class_4696.method_23680(fluidState);
            var buffer = buffers.getBuffer(layer);
            blockRenderer.method_3352(pos, multiblock, new FluidBlockVertexConsumer(buffer, ps, pos), state, fluidState);
        }
        if (state.method_26217() != class_2464.field_11455) {
//            var layer = ItemBlockRenderTypes.getChunkRenderType(state);
//            var buffer = buffers.getBuffer(layer);
//            blockRenderer.renderBatched(state, pos, multiblock, ps, buffer, false, rand);
            //batched rendering has changed significantly
            blockRenderer.method_3353(state, ps, buffers, class_765.field_32767, class_4608.field_21444);
        }
    }
}
