// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import net.minecraft.class_1109;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_7923;

public class BookContentRenderer {

    private static long lastTurnPageSoundTime;

    public static void drawFromContentTexture(Function<class_2960, class_1921> renderTypeGetter, class_332 guiGraphics, Book book, int x, int y, int u, int v, int w, int h) {
        guiGraphics.method_25290(renderTypeGetter, book.getBookContentTexture(), x, y, u, v, w, h, 512, 256);
    }

    public static void drawTitleSeparator(class_332 guiGraphics, Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x - w / 2;

        RenderSystem.setShaderColor(1F, 1F, 1F, 0.8F);
        //u and v are the pixel coordinates in our book_content_texture
        drawFromContentTexture(class_1921::method_62275, guiGraphics, book, rx, y, 0, 253, w, h);
        RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
    }

    public static void drawLock(class_332 guiGraphics, Book book, int x, int y) {
        drawFromContentTexture(class_1921::method_62275, guiGraphics, book, x, y, 496, 0, 16, 16);
    }

    public static void playTurnPageSound(Book book) {
        if (ClientTicks.ticks - lastTurnPageSoundTime > 6) {
            var sound = class_7923.field_41172.method_63535(book.getTurnPageSound());
            class_310.method_1551().method_1483().method_4873(class_1109.method_4758(sound, (float) (0.7 + Math.random() * 0.3)));
            lastTurnPageSoundTime = ClientTicks.ticks;
        }
    }

    public static void renderBookBackground(class_332 guiGraphics, class_2960 bookContentTexture) {
        int x = 0; // (this.width - BOOK_BACKGROUND_WIDTH) / 2;
        int y = 0; // (this.height - BOOK_BACKGROUND_HEIGHT) / 2;

        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        guiGraphics.method_25290(class_1921::method_62277, bookContentTexture, x, y, 0, 0, 272, 178, 512, 256);
    }


}
