/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book.button;

import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Gui;
import com.klikli_dev.modonomicon.client.gui.book.BookParentScreen;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8001;


public class ReadAllButton extends class_4185 {

    public static final int U = 0;
    public static final int V_READ_UNLOCKED = 196;
    public static final int V_READ_ALL = 210;
    public static final int V_NONE = 224;
    public static final int WIDTH = 16;
    public static final int HEIGHT = 14;


    private final BookParentScreen parent;

    private final class_5250 tooltipReadUnlocked;
    private final class_5250 tooltipReadAll;
    private final class_5250 tooltipNone;
    private final class_5250 tooltipShiftInstructions;
    private final class_5250 tooltipShiftWarning;
    private final Supplier<Boolean> displayCondition;
    private final Supplier<Boolean> hasUnreadUnlockedEntries;

    private boolean wasHovered;
    private int tooltipMsDelay;
    private long hoveredStartTime;


    public ReadAllButton(BookParentScreen parent, int x, int y, Supplier<Boolean> hasUnreadUnlockedEntries, Supplier<Boolean> displayCondition, class_4241 onPress) {
        super(x, y, WIDTH, HEIGHT,
                class_2561.method_43471(Gui.BUTTON_READ_ALL),
                onPress, class_4185.field_40754
        );
        this.parent = parent;
        this.tooltipReadUnlocked = class_2561.method_43471(Gui.BUTTON_READ_ALL_TOOLTIP_READ_UNLOCKED);
        this.tooltipReadAll = class_2561.method_43471(Gui.BUTTON_READ_ALL_TOOLTIP_READ_ALL);
        this.tooltipNone = class_2561.method_43471(Gui.BUTTON_READ_ALL_TOOLTIP_NONE);
        this.tooltipShiftInstructions = class_2561.method_43471(Gui.BUTTON_READ_ALL_TOOLTIP_SHIFT_INSTRUCTIONS);
        this.tooltipShiftWarning = class_2561.method_43471(Gui.BUTTON_READ_ALL_TOOLTIP_SHIFT_WARNING);
        this.hasUnreadUnlockedEntries = hasUnreadUnlockedEntries;
        this.displayCondition = displayCondition;
    }

    @Override
    public final void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.field_22763 = this.field_22764 = this.displayCondition.get();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.updateCustomTooltip();
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        //if focused we go to the right of our normal button (instead of down, like mc buttons do)

        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0, 0, 200);
        var hovered = this.method_49606();

        int u = U;

        //by default we show green if we can read unlocked entries or gray if none
        //if shift is down we offer to mark all as read
        //if neither is possible the button should be hidden which is handled by BookOverviewScreen#canSeeReadAllButton
        int v = this.hasUnreadUnlockedEntries.get() ? V_READ_UNLOCKED : V_NONE;

        if (hovered)
            u += this.field_22758; //shift to the right for hover variant

        if (class_437.method_25442()) {
            v = V_READ_ALL;
        }

        RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
        guiGraphics.method_25290(class_1921::method_62277, this.parent.getBook().getBookOverviewTexture(), this.method_46426(), this.method_46427(), u, v, this.field_22758, this.field_22759, 256, 256);

        guiGraphics.method_51448().method_22909();
    }

    private void updateCustomTooltip() {

        boolean flag = this.method_49606();
        if (flag != this.wasHovered) {
            if (flag) {
                this.hoveredStartTime = class_156.method_658();
            }

            this.wasHovered = flag;
        }

        if (flag && class_156.method_658() - this.hoveredStartTime > (long) this.tooltipMsDelay) {
            var tooltip = this.getCustomTooltip();

            class_437 screen = ClientServices.GUI.getCurrentScreen();
            if (screen != null) {
                screen.method_47412(class_7919.method_47407(tooltip), class_8001.field_41687, this.method_49606());
            }
        }

    }

    public class_5250 getCustomTooltip() {

        if (class_437.method_25442()) {
            return class_2561.method_43473().method_10852(this.tooltipReadAll).method_10852(class_2561.method_43470("\n\n")).method_10852(this.tooltipShiftWarning);
        }

        if (this.hasUnreadUnlockedEntries.get()) {
            return class_2561.method_43473().method_10852(this.tooltipReadUnlocked).method_10852(class_2561.method_43470("\n\n")).method_10852(this.tooltipShiftInstructions);
        }

        return class_2561.method_43473().method_10852(this.tooltipNone).method_10852(class_2561.method_43470("\n\n")).method_10852(this.tooltipShiftInstructions);
    }

}
