// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler;

import com.klikli_dev.modonomicon.book.CommandLink;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.ClickCommandLinkMessage;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.class_2558;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class CommandLinkHandler extends LinkHandler {
    public CommandLinkHandler(BookEntryScreen screen) {
        super(screen);
    }

    @Override
    public ClickResult handleClick(@NotNull class_2583 pStyle) {
        var event = pStyle.method_10970();
        if (event == null)
            return ClickResult.UNHANDLED;

        //Command links use RUN_COMMAND action, but the command string is not a vanilla string, instead it is a custom protocol string.
        //the isCommandLink below will check for a protocol prefix
        if (event.method_10845() != class_2558.class_2559.field_11750 || !(event instanceof class_2558.class_10609 runCommand))
            return ClickResult.UNHANDLED;

        if (!CommandLink.isCommandLink(runCommand.comp_3506()))
            return ClickResult.UNHANDLED;

        var link = CommandLink.from(this.book(), runCommand.comp_3506());
        var book = BookDataManager.get().getBook(link.bookId);
        if (link.commandId == null)
            return ClickResult.FAILURE;

        var command = book.getCommand(link.commandId);

        if (BookUnlockStateManager.get().canRunFor(this.player(), command)) {
            Services.NETWORK.sendToServer(new ClickCommandLinkMessage(link.bookId, link.commandId));

            //we immediately count up the usage client side -> to avoid spamming the server
            //if the server ends up not counting up the usage, it will sync the correct info back down to us
            //We should only do that on the client connected to a dedicated server, because on the integrated server we would count usage twice
            //that means, for singleplayer clients OR clients that share to lan we dont call the setRunFor
            if (class_310.method_1551().method_1576() == null)
                BookUnlockStateManager.get().setRunFor(this.player(), command);
        }

        return ClickResult.SUCCESS;
    }
}
