/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class MarkdownComponentRenderUtils {
    /**
     * Adopted from
     * {@link net.minecraft.class_341#method_1850(class_5348, int, class_327)} Wraps
     * translatable components and gracefully handles markdown lists.
     *
     * @param text      the text to wrap.
     * @param width     the max width of the text to wrap at
     * @param listWidth the alternate width to use for lists. This is a hack to avoid issues with indent for wrapped
     *                  lines causing the lines to exceed the width. Could be e.g. width-10
     * @param font      The font to use, will usually be Minecraft.getInstance().font;
     * @return a list of wrapped lines ready to render via font.
     */
    public static List<class_5481> wrapComponents(class_5250 text, int width, int listWidth, class_327 font) {
        if (text.method_10851() instanceof ListItemContents) {
            width = listWidth;
        }

        List<class_5481> list = Lists.newArrayList();
        font.method_27527().method_29971(text, width, class_2583.field_24360, (lineText, isWrapped) -> {
            class_5481 formattedcharsequence = class_2477.method_10517().method_30934(lineText);
            var indent = class_5481.field_26385;
            if (text.method_10851() instanceof ListItemContents item) {
                indent = class_5481.method_30747(item.getListHolder().getIndent() + "   ", class_2583.field_24360);
            }
            list.add(isWrapped ? class_5481.method_30742(indent, formattedcharsequence) : formattedcharsequence);
        });
        return (list.isEmpty() ? Lists.newArrayList(class_5481.field_26385) : list);
    }
}
