/*
 * SPDX-FileCopyrightText: 2022 Authors of Patchouli
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.render;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.MultiblockPreviewData;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.multiblock.AbstractMultiblock;
import com.klikli_dev.modonomicon.multiblock.matcher.DisplayOnlyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.Matchers;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.awt.*;
import java.util.*;
import java.util.function.Function;
import net.minecraft.class_10149;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_827;
import net.minecraft.class_898;
import net.minecraft.class_9799;
import net.minecraft.class_9801;

public class MultiblockPreviewRenderer {

    private static final Map<class_2338, class_2586> blockEntityCache = new Object2ObjectOpenHashMap<>();
    private static final Set<class_2586> erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap<>());
    public static boolean hasMultiblock;
    private static Multiblock multiblock;
    private static class_2561 name;
    private static class_2338 pos;
    private static boolean isAnchored;
    private static class_2470 facingRotation;
    private static Function<class_2338, class_2338> offsetApplier;
    private static int blocks, blocksDone, airFilled;
    private static int timeComplete;
    private static class_2680 lookingState;
    private static class_2338 lookingPos;
    private static class_4597.class_4598 buffers = null;

    public static void setMultiblock(Multiblock multiblock, class_2561 name, boolean flip) {
        setMultiblock(multiblock, name, flip, pos -> pos);
    }

    public static void setMultiblock(Multiblock multiblock, class_2561 name, boolean flip, Function<class_2338, class_2338> offsetApplier) {
        if (flip && hasMultiblock && MultiblockPreviewRenderer.multiblock == multiblock) {
            hasMultiblock = false;
        } else {
            MultiblockPreviewRenderer.multiblock = multiblock;
            MultiblockPreviewRenderer.blockEntityCache.clear();
            MultiblockPreviewRenderer.erroredBlockEntities.clear();
            MultiblockPreviewRenderer.name = name;
            MultiblockPreviewRenderer.offsetApplier = offsetApplier;
            pos = null;
            hasMultiblock = multiblock != null;
            isAnchored = false;
        }
    }

    public static void onRenderHUD(class_332 guiGraphics, float partialTicks) {
        if (hasMultiblock) {
            int waitTime = 40;
            int fadeOutSpeed = 4;
            int fullAnimTime = waitTime + 10;
            float animTime = timeComplete + (timeComplete == 0 ? 0 : partialTicks);

            if (animTime > fullAnimTime) {
                hasMultiblock = false;
                return;
            }

            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0, -Math.max(0, animTime - waitTime) * fadeOutSpeed, 0);

            class_310 mc = class_310.method_1551();
            int x = mc.method_22683().method_4486() / 2;
            int y = 12;

            GuiGraphicsExt.drawString(guiGraphics, mc.field_1772, name, x - mc.field_1772.method_27525(name) / 2.0F, y, 0xFFFFFF, false);

            int width = 180;
            int height = 9;
            int left = x - width / 2;
            int top = y + 10;

            if (timeComplete > 0) {
                String s = class_1074.method_4662(ModonomiconConstants.I18n.Multiblock.COMPLETE);
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(0, Math.min(height + 5, animTime), 0);
                guiGraphics.method_51433(mc.field_1772, s, (int) (x - mc.field_1772.method_1727(s) / 2.0F), top + height - 10, 0x00FF00, false);
                guiGraphics.method_51448().method_22909();
            }
            guiGraphics.method_51448().method_22903();

            //render a black square at the "bottom", 1px larger than the actual progress bar, so it acts as a border
            guiGraphics.method_25294(left - 1, top - 1, left + width + 1, top + height + 1, 0xFF000000);

            //then, on top of that, render a gray gradient as "empty progress"
            guiGraphics.method_25296(left, top, left + width, top + height, 0xFF666666, 0xFF666666);

            float fract = (float) blocksDone / Math.max(1, blocks);
            int progressWidth = (int) ((float) width * fract);
            int color = class_3532.method_15369(fract / 3.0F, 1.0F, 1.0F) | 0xFF000000;
            int color2 = new Color(color).darker().getRGB();

            //finally, on top of that, render a colored gradient as "filled progress"
            guiGraphics.method_25296(left, top, left + progressWidth, top + height, color, color2);

            guiGraphics.method_51448().method_22909();
            if (!isAnchored) {
                String s = class_1074.method_4662(ModonomiconConstants.I18n.Multiblock.NOT_ANCHORED);
                guiGraphics.method_51433(mc.field_1772, s, (int) (x - mc.field_1772.method_1727(s) / 2.0F), top + height + 8, 0xFFFFFF, false);
            } else {
                if (lookingState != null) {
                    // try-catch around here because the state isn't necessarily present in the world in this instance,
                    // which isn't really expected behavior for getPickBlock
                    try {
                        var stack = lookingState.method_65171(mc.field_1687, lookingPos, true);
                        if (!stack.method_7960()) {
                            guiGraphics.method_51439(mc.field_1772, stack.method_7964(), left + 20, top + height + 8, 0xFFFFFF, false);

                            guiGraphics.method_51427(stack, left, top + height + 2);
                        }
                    } catch (Exception ignored) {
                    }
                }

                if (timeComplete == 0) {
                    color = 0xFFFFFF;
                    int posx = left + width;
                    int posy = top + height + 2;
                    float mult = 1;
                    String progress = blocksDone + "/" + blocks;

                    if (blocksDone == blocks && airFilled > 0) {
                        progress = class_1074.method_4662(ModonomiconConstants.I18n.Multiblock.REMOVE_BLOCKS);
                        color = 0xDA4E3F;
                        mult *= 2;
                        posx -= width / 2;
                        posy += 2;
                    }

                    guiGraphics.method_51433(mc.field_1772, progress, (int) (posx - mc.field_1772.method_1727(progress) / mult), posy, color, true);
                }
            }

            guiGraphics.method_51448().method_22909();
        }
    }

    public static void onRenderLevelLastEvent(class_4587 poseStack) {
        if (hasMultiblock && multiblock != null) {
            renderMultiblock(class_310.method_1551().field_1687, poseStack);
        }
    }

    public static void anchorTo(class_2338 target, class_2470 rot) {
        pos = target;
        facingRotation = rot;
        isAnchored = true;
    }

    public static class_1269 onPlayerInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        if (hasMultiblock && !isAnchored && player == class_310.method_1551().field_1724) {
            anchorTo(hit.method_17777(), getRotation(player));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static void onClientTick(class_310 mc) {
        if (class_310.method_1551().field_1687 == null) {
            hasMultiblock = false;
        } else if (isAnchored && blocks == blocksDone && airFilled == 0) {
            timeComplete++;
            if (timeComplete == 14) {
                class_310.method_1551().method_1483().method_4873(class_1109.method_4758(class_3417.field_14627, 1.0F));
            }
        } else {
            timeComplete = 0;
        }
    }

    public static void renderMultiblock(class_1937 level, class_4587 ms) {
        class_310 mc = class_310.method_1551();
        if (!isAnchored) {
            facingRotation = getRotation(mc.field_1724);
            if (mc.field_1765 instanceof class_3965) {
                pos = ((class_3965) mc.field_1765).method_17777();
            }
        } else if (pos.method_19770(mc.field_1724.method_19538()) > 64 * 64) {
            return;
        }

        if (pos == null) {
            return;
        }
        if (multiblock.isSymmetrical()) {
            facingRotation = class_2470.field_11467;
        }

        multiblock.setLevel(level);

        class_898 erd = mc.method_1561();
        double renderPosX = erd.field_4686.method_19326().method_10216();
        double renderPosY = erd.field_4686.method_19326().method_10214();
        double renderPosZ = erd.field_4686.method_19326().method_10215();
        ms.method_22903();
        ms.method_22904(-renderPosX, -renderPosY, -renderPosZ);

        if (buffers == null) {
            buffers = initBuffers(mc.method_22940().method_23000());
        }

        class_2338 checkPos = null;
        if (mc.field_1765 instanceof class_3965 blockRes) {
            checkPos = blockRes.method_17777().method_10093(blockRes.method_17780());
        }

        blocks = blocksDone = airFilled = 0;
        lookingState = null;
        lookingPos = checkPos;

        class_2338 startPos = getStartPos();

        Pair<class_2338, Collection<Multiblock.SimulateResult>> sim = multiblock.simulate(level, startPos, getFacingRotation(), true, false);
        for (Multiblock.SimulateResult r : sim.getSecond()) {
            float alpha = 0.3F;
            if (r.getWorldPosition().equals(checkPos)) {
                lookingState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks);
                alpha = 0.6F + (float) (Math.sin(ClientTicks.total * 0.3F) + 1F) * 0.1F;
            }

            if (!r.getStateMatcher().equals(Matchers.ANY) && r.getStateMatcher().getType() != DisplayOnlyMatcher.TYPE) {
                boolean air = !r.getStateMatcher().countsTowardsTotalBlocks();
                if (!air) {
                    blocks++;
                }

                if (!r.test(level, facingRotation)) {
                    class_2680 renderState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).method_26186(facingRotation);
                    renderBlock(level, renderState, r.getWorldPosition(), multiblock, air, alpha, ms);

                    if (renderState.method_26204() instanceof class_2343 eb) {

                        //if our cached be is not compatible with the render state, remove it.
                        //this happens e.g. if there is a blocktag that contains multible blocks with different BEs
                        //we also have to translate by startpos to counteract the preview moving in the world (but the BE cache being static)
                        var be = blockEntityCache.compute(r.getWorldPosition().method_10059(startPos).method_10062(), (p, cachedBe) -> {
                            if (cachedBe != null && !cachedBe.method_11017().method_20526(renderState)) {
                                return eb.method_10123(p, renderState);
                            }
                            return cachedBe != null ? cachedBe : eb.method_10123(p, renderState);
                        });
                        if (be != null && !erroredBlockEntities.contains(be)) {
                            be.method_31662(mc.field_1687);

                            // fake cached state in case the renderer checks it as we don't want to query the actual world
                            be.method_31664(renderState);

                            ms.method_22903();
                            var bePos = r.getWorldPosition();
                            ms.method_46416(bePos.method_10263(), bePos.method_10264(), bePos.method_10260());

                            try {
                                class_827<class_2586> renderer = class_310.method_1551().method_31975().method_3550(be);
                                if (renderer != null) {
                                    renderer.method_3569(be, ClientTicks.partialTicks, ms, buffers, 0xF000F0, class_4608.field_21444, erd.field_4686.method_19326());
                                }
                            } catch (Exception e) {
                                erroredBlockEntities.add(be);
                                Modonomicon.LOG.error("Error rendering block entity", e);
                            }
                            ms.method_22909();
                        }
                    }

                    if (air) {
                        airFilled++;
                    }
                } else if (!air) {
                    blocksDone++;
                }
            }
        }

        buffers.method_22993();
        ms.method_22909();

        if (!isAnchored) {
            blocks = blocksDone = 0;
        }
    }

    public static void renderBlock(class_1937 world, class_2680 state, class_2338 pos, Multiblock multiblock, boolean isAir, float alpha, class_4587 ms) {
        if (pos != null) {
            ms.method_22903();
            ms.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());

            if (state.method_26204() == class_2246.field_10124) {
                float scale = 0.3F;
                float off = (1F - scale) / 2;
                ms.method_46416(off, off, off);
                ms.method_22905(scale, scale, scale);

                state = class_2246.field_10058.method_9564();
            }

            ClientServices.MULTIBLOCK.renderBlock(state, pos, multiblock, ms, buffers, world.method_8409());

//            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, ms, buffers, 0xF000F0, OverlayTexture.NO_OVERLAY);

            ms.method_22909();
        }
    }

    @Nullable
    public static MultiblockPreviewData getMultiblockPreviewData() {
        if (!hasMultiblock) {
            return null;
        }
        return new MultiblockPreviewData(multiblock, pos, facingRotation, isAnchored);
    }

    public static Multiblock getMultiblock() {
        return multiblock;
    }

    public static boolean isAnchored() {
        return isAnchored;
    }

    public static class_2470 getFacingRotation() {
        return multiblock.isSymmetrical() ? class_2470.field_11467 : facingRotation;
    }

    public static class_2338 getStartPos() {
        return offsetApplier.apply(pos);
    }

    /**
     * Returns the Rotation of a multiblock structure based on the given entity's facing direction.
     */
    private static class_2470 getRotation(class_1297 entity) {
        return AbstractMultiblock.rotationFromFacing(entity.method_5735());
    }

    private static class_4597.class_4598 initBuffers(class_4597.class_4598 original) {
        var fallback = original.field_52156;
        var layerBuffers = original.field_20953;
        SequencedMap<class_1921, class_9799> remapped = new Object2ObjectLinkedOpenHashMap<>();
        for (Map.Entry<class_1921, class_9799> e : layerBuffers.entrySet()) {
            remapped.put(GhostRenderType.remap(e.getKey()), e.getValue());
        }
        return new GhostBuffers(fallback, remapped);
    }

    private static class GhostBuffers extends class_4597.class_4598 {
        protected GhostBuffers(class_9799 fallback, SequencedMap<class_1921, class_9799> layerBuffers) {
            super(fallback, layerBuffers);
        }

        @Override
        public class_4588 getBuffer(class_1921 type) {
            return super.getBuffer(GhostRenderType.remap(type));
        }
    }

    private static class GhostRenderType extends class_1921 {
        private static final Map<class_1921, class_1921> remappedTypes = new IdentityHashMap<>();

        private final RenderPipeline pipeline;
        private final class_1921 original;

        private GhostRenderType(class_1921 original, RenderPipeline pipeline) {
            super(String.format("%s_%s_ghost", original.toString(), ModonomiconAPI.ID), original.method_22722(), original.method_23037(), true, () -> {

                original.method_23516();
//                RenderSystem.disableDepthTest();
//                RenderSystem.enableBlend();
                //don't need the above, now in pipeline
                RenderSystem.setShaderColor(1, 1, 1, 0.4F);
            }, () -> {
                RenderSystem.setShaderColor(1, 1, 1, 1);
//                RenderSystem.disableBlend();
//                RenderSystem.enableDepthTest();
                //don't need the above, now in pipeline

                original.method_23518();
            });

            this.pipeline = pipeline;
            this.original = original;
        }

        public static class_1921 remap(class_1921 in) {
            if (in instanceof GhostRenderType) {
                return in;
            } else {
                return remappedTypes.computeIfAbsent(in, (type) -> {
                    //TODO: Do we need cutout/entity handling still?
//                    //hack to address https://github.com/klikli-dev/modonomicon/issues/260, but it should work reasonably well
//                    //need to exclude entity, because otherwise entity cutout layers will render using the block atlas.
//                    if (type.name.contains("cutout") && !type.name.contains("entity"))
//                        type = RenderType.translucent();

                    //modify the pipeline
                    var pipeline = toBuilder(in.method_68495())
                            .withBlend(BlendFunction.TRANSLUCENT)
                            .withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST);

                    return new GhostRenderType(type, pipeline.build());
                });
            }
        }

        public static RenderPipeline.Builder toBuilder(RenderPipeline pipeline) {
            RenderPipeline.Builder builder = RenderPipeline.builder();
            builder.withLocation(pipeline.getLocation());
            builder.withFragmentShader(pipeline.getFragmentShader());
            builder.withVertexShader(pipeline.getVertexShader());

            if (!pipeline.getShaderDefines().method_62930()) {
                class_10149.class_10150 defBuilder = class_10149.method_62926();
                for (Map.Entry<String, String> entry : pipeline.getShaderDefines().comp_3103().entrySet()) {
                    defBuilder.method_62934(entry.getKey(), entry.getValue());
                }
                for (String flag : pipeline.getShaderDefines().comp_3104()) {
                    defBuilder.method_62932(flag);
                }
                builder.definesBuilder = Optional.of(defBuilder);
            }

            if (!pipeline.getSamplers().isEmpty()) {
                pipeline.getSamplers().forEach(builder::withSampler);
            }

            if (!pipeline.getUniforms().isEmpty()) {
                pipeline.getUniforms().forEach(u -> builder.withUniform(u.name(), u.type()));
            }

            builder.withDepthTestFunction(pipeline.getDepthTestFunction());
            builder.withPolygonMode(pipeline.getPolygonMode());
            builder.withCull(pipeline.isCull());
            builder.withColorWrite(pipeline.isWriteColor(), pipeline.isWriteAlpha());
            builder.withDepthWrite(pipeline.isWriteDepth());
            builder.withColorLogic(pipeline.getColorLogic());

            if (!pipeline.getBlendFunction().isEmpty())
                builder.withBlend(pipeline.getBlendFunction().get());
            else
                builder.withoutBlend();
            builder.withVertexFormat(pipeline.getVertexFormat(), pipeline.getVertexFormatMode());
            builder.withDepthBias(pipeline.getDepthBiasScaleFactor(), pipeline.getDepthBiasConstant());

            return builder;
        }

        @Override
        public void method_60895(@NotNull class_9801 meshData) {
            //TODO: this is not working yet, it's not using the pipeline translucency settings
            //overlay works but looks horrible
            if (this.original instanceof class_4687 composite) {
                var oldPipeline = this.original.method_68495();
                composite.field_56922 = this.pipeline; //set our own modified pipeline
                this.original.method_60895(meshData);
                composite.field_56922 = oldPipeline; //restore
            } else {
                this.original.method_60895(meshData);
            }
        }

        @Override
        public @NotNull class_276 method_68494() {
            return this.original.method_68494();
        }

        @Override
        public @NotNull RenderPipeline method_68495() {
            return this.pipeline; //get our own modified pipeline
        }

        @Override
        public @NotNull VertexFormat method_23031() {
            return this.original.method_23031();
        }

        @Override
        public VertexFormat.@NotNull class_5596 method_23033() {
            return this.original.method_23033();
        }

    }
}
