/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.book.page.BookProcessingRecipePage;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_10297;
import net.minecraft.class_10363;
import net.minecraft.class_1860;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_332;

public abstract class BookProcessingRecipePageRenderer<T extends class_1860<?>> extends BookRecipePageRenderer<T, BookProcessingRecipePage<T>> {
    public BookProcessingRecipePageRenderer(BookProcessingRecipePage<T> page) {
        super(page);
    }

    @Override
    protected int getRecipeHeight() {
        return 45;
    }

    @Override
    protected void drawRecipe(class_332 guiGraphics, class_10297 recipeDisplayEntry, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {

        recipeY += 10;

        if (!second) {
            if (!this.page.getTitle1().isEmpty()) {
                this.renderTitle(guiGraphics, this.page.getTitle1(), false, BookEntryScreen.PAGE_WIDTH / 2, 0);
            }
        } else {
            if (!this.page.getTitle2().isEmpty()) {
                this.renderTitle(guiGraphics, this.page.getTitle2(), false, BookEntryScreen.PAGE_WIDTH / 2,
                        recipeY - (this.page.getTitle2().getString().isEmpty() ? 10 : 0) - 10);
            }
        }

        guiGraphics.method_25290(class_1921::method_62275, this.page.getBook().getCraftingTexture(), recipeX, recipeY, 11, 71, 96, 24, 128, 256);
        guiGraphics.method_25290(class_1921::method_62275, this.page.getBook().getCraftingTexture(), recipeX, recipeY, 11, 71, 96, 24, 128, 256);
        //noinspection DataFlowIssue
        var context = class_10363.method_65008(class_310.method_1551().field_1687);
        this.parentScreen.renderIngredient(guiGraphics, recipeX + 4, recipeY + 4, mouseX, mouseY, recipeDisplayEntry.comp_3266().map(List::getFirst).orElseThrow());
        this.parentScreen.renderItemStacks(guiGraphics, recipeX + 40, recipeY + 4, mouseX, mouseY, recipeDisplayEntry.comp_3263().comp_3259().method_64738(context));
        this.parentScreen.renderItemStacks(guiGraphics, recipeX + 76, recipeY + 4, mouseX, mouseY, recipeDisplayEntry.comp_3263().comp_3258().method_64738(context));
    }
}
