/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.command;

import com.klikli_dev.modonomicon.api.ModonomiconConstants.I18n.Command;
import com.klikli_dev.modonomicon.networking.SendUnlockCodeToServerMessage;
import com.klikli_dev.modonomicon.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Base64;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class LoadUnlocksCommand implements com.mojang.brigadier.Command<class_2168> {

    private static final LoadUnlocksCommand CMD = new LoadUnlocksCommand();


    public static ArgumentBuilder<class_2168, ?> register(CommandDispatcher<class_2168> dispatcher) {

        return class_2170.method_9247("load_progress")
                .requires(cs -> cs.method_9259(1))
                .executes(CMD);
    }

    @Override
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        var code = class_310.method_1551().field_1774.method_1460();

        try {
            if (code.isEmpty())
                throw new IllegalArgumentException("No code in clipboard.");

            var decoded = Base64.getDecoder().decode(code);

            if (decoded.length == 0)
                throw new IllegalArgumentException("Decoded code is zero-length.");

            Services.NETWORK.sendToServer(new SendUnlockCodeToServerMessage(code));

            return 1;
        } catch (Exception e) {
            context.getSource().method_9213(class_2561.method_43469(Command.ERROR_LOAD_PROGRESS_CLIENT, code));
            return 0;
        }
    }
}
