/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.datagen;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_10410;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4943;
import net.minecraft.class_4944;

public class ModonomiconModelProvider extends FabricModelProvider {
    public ModonomiconModelProvider(FabricDataOutput packOutput) {
        super(packOutput);
    }

    public void generateFlatItem(class_1792 item, String texture, class_4915 itemModelGenerator) {
        itemModelGenerator.field_55245.method_65460(item, class_10410.method_65481(this.createFlatItemModel(item, texture, itemModelGenerator)));
    }

    public class_2960 createFlatItemModel(class_1792 item, String texture, class_4915 itemModelGenerator) {
        return class_4943.field_22938.method_25852(class_4941.method_25840(item),
                class_4944.method_25895(Modonomicon.loc("item/" + texture)),
                itemModelGenerator.field_55246);
    }


    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {

    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        this.generateFlatItem(ItemRegistry.MODONOMICON.get(), "modonomicon_purple", itemModelGenerator);
        this.generateFlatItem(ItemRegistry.MODONOMICON_BLUE.get(), "modonomicon_blue", itemModelGenerator);
        this.generateFlatItem(ItemRegistry.MODONOMICON_GREEN.get(), "modonomicon_green", itemModelGenerator);
        this.generateFlatItem(ItemRegistry.MODONOMICON_PURPLE.get(), "modonomicon_purple", itemModelGenerator);
        this.generateFlatItem(ItemRegistry.MODONOMICON_RED.get(), "modonomicon_red", itemModelGenerator);
        this.generateFlatItem(ItemRegistry.LEAFLET.get(), "leaflet", itemModelGenerator);
    }
}
