// SPDX-FileCopyrightText: 2024 klikli-dev
//
// SPDX-License-Identifier: MIT

package com.klikli_dev.modonomicon.datagen.book.demo.indexmode;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1802;

public class Demo2IndexEntry extends EntryProvider {
    public static final String ID = "demo2";

    public Demo2IndexEntry(CategoryProvider parent) {
        super(parent);
    }

    @Override
    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create()
                .withTitle(this.context().pageTitle())
                .withText(this.context().pageText())
        );
        this.pageTitle("Demo");
        this.pageText("""
                Demo
                """);
    }

    @Override
    protected String entryName() {
        return "Demo Entry 2";
    }

    @Override
    protected String entryDescription() {
        return "Just Demo Stuff (tm). But with a very long entry description to see if tooltip rendering properly works!";
    }

    @Override
    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    @Override
    protected BookIconModel entryIcon() {
        return BookIconModel.create(class_1802.field_16307);
    }

    @Override
    protected String entryId() {
        return ID;
    }
}
