package com.klikli_dev.modonomicon.mixin;

import com.google.common.collect.Multimap;
import com.klikli_dev.modonomicon.client.BookModel;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_10418;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_5599;

@Mixin(class_1092.class)
public class MixinModelManager {
    /**
     * This mixes into the synthethic method created for the lambda "return modelBakery.bakeModels(new SpriteGetter() { ... }, executor).thenApply((bakingResult) -> { });" in ModelManager#loadModels. There we can access the bakingResult
     */
    @Inject(
            method = "method_68047(Lcom/google/common/collect/Multimap;Lcom/google/common/collect/Multimap;Lit/unimi/dsi/fastutil/objects/Object2IntMap;Ljava/util/Map;Lnet/minecraft/client/model/geom/EntityModelSet;Lnet/minecraft/client/renderer/SpecialBlockModelRenderer;Ljava/util/concurrent/CompletableFuture;Lnet/minecraft/client/resources/model/ModelBakery$BakingResult;)Lnet/minecraft/client/resources/model/ModelManager$ReloadState;",
            at = @At("HEAD")
    )
    private static void onMethod68047(
            Multimap<?, ?> multimap,
            Multimap<?, ?> multimap2,
            Object2IntMap<?> object2IntMap,
            Map<?, ?> map,
            class_5599 entityModelSet,
            class_10418 specialBlockModelRenderer,
            CompletableFuture<?> completableFuture,
            class_1088.class_10524 bakingResult,
            CallbackInfoReturnable<class_1092.class_7779> cir
    ) {
        BookModel.replace(bakingResult.comp_3432());
        // Your code here
    }
}
