/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class ClickCommandLinkMessage implements Message {

    public static final class_8710.class_9154<ClickCommandLinkMessage> TYPE = new class_8710.class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "click_command_link"));


    public static final class_9139<class_9129, ClickCommandLinkMessage> STREAM_CODEC = class_9139.method_56435(
            class_2960.field_48267,
            (m) -> m.bookId,
            class_2960.field_48267,
            (m) -> m.commandId,
            ClickCommandLinkMessage::new
    );

    public class_2960 bookId;
    public class_2960 commandId;

    public ClickCommandLinkMessage(class_2960 bookId, class_2960 commandId) {
        this.bookId = bookId;
        this.commandId = commandId;
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var book = BookDataManager.get().getBook(this.bookId);
        if (book != null) {
            var command = book.getCommand(this.commandId);
            if (command != null) {
                command.execute(player);
            }
        }
    }
}
