/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class OpenBookOnClientMessage implements Message {

    public static final class_9154<OpenBookOnClientMessage> TYPE = new class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "open_book_on_client"));

    public static final class_9139<class_9129, OpenBookOnClientMessage> STREAM_CODEC = class_9139.method_56434(
            class_2960.field_48267,
            (m) -> m.bookId,
            OpenBookOnClientMessage::new
    );

    public class_2960 bookId;

    public OpenBookOnClientMessage(class_2960 bookId) {
        this.bookId = bookId;
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onClientReceived(class_310 minecraft, class_1657 player) {
        var book = BookDataManager.get().getBook(this.bookId);
        if (book != null) {
            BookGuiManager.get().openBook(BookAddress.defaultFor(book));
        }
    }
}
