/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.CategoryVisualState;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class SaveCategoryStateMessage implements Message {

    public static final class_9154<SaveCategoryStateMessage> TYPE = new class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "save_category_state"));
    public static final class_9139<class_9129, SaveCategoryStateMessage> STREAM_CODEC = class_8710.method_56484(SaveCategoryStateMessage::encode, SaveCategoryStateMessage::new);

    public BookCategory category;

    public float scrollX = 0;
    public float scrollY = 0;
    public float targetZoom;

    public class_2960 openEntry = null;

    public SaveCategoryStateMessage(BookCategory category, CategoryVisualState state) {
        this(category, state.scrollX, state.scrollY, state.targetZoom, state.openEntry);
    }

    public SaveCategoryStateMessage(BookCategory category, float scrollX, float scrollY, float targetZoom, class_2960 openEntry) {
        this.category = category;
        this.scrollX = scrollX;
        this.scrollY = scrollY;
        this.targetZoom = targetZoom;
        this.openEntry = openEntry;
    }

    public SaveCategoryStateMessage(class_9129 buf) {
        this.decode(buf);
    }

    private void encode(class_9129 buf) {
        buf.method_10812(this.category.getBook().getId());
        buf.method_10812(this.category.getId());
        buf.method_52941(this.scrollX);
        buf.method_52941(this.scrollY);
        buf.method_52941(this.targetZoom);
        buf.method_52964(this.openEntry != null);
        if (this.openEntry != null) {
            buf.method_10812(this.openEntry);
        }
    }

    private void decode(class_9129 buf) {
        this.category = BookDataManager.get().getBook(buf.method_10810()).getCategory(buf.method_10810());
        this.scrollX = buf.readFloat();
        this.scrollY = buf.readFloat();
        this.targetZoom = buf.readFloat();
        if (buf.readBoolean()) {
            this.openEntry = buf.method_10810();
        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, class_3222 player) {
        var currentState = BookVisualStateManager.get().getCategoryStateFor(player, this.category);
        currentState.scrollX = this.scrollX;
        currentState.scrollY = this.scrollY;
        currentState.targetZoom = this.targetZoom;
        currentState.openEntry = this.openEntry;
        BookVisualStateManager.get().setCategoryStateFor(player, this.category, currentState);
        BookVisualStateManager.get().syncFor(player);
    }
}
