/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class SyncBookDataMessage implements Message {


    public static final class_9154<SyncBookDataMessage> TYPE = new class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "sync_book_data"));
    public static final class_9139<class_9129, SyncBookDataMessage> STREAM_CODEC = class_8710.method_56484(SyncBookDataMessage::encode, SyncBookDataMessage::new);

    //We use an array map here because we are not actually doing any lookups, we just iterate over the values
    public Map<class_2960, Book> books = new Object2ObjectArrayMap<>();

    public SyncBookDataMessage(Map<class_2960, Book> books) {
        //We use an array map here because we are not actually doing any lookups, we just iterate over the values
        this.books = new Object2ObjectArrayMap<>(books);
    }

    public SyncBookDataMessage(class_9129 buf) {
        this.decode(buf);
    }

    private void encode(class_9129 buf) {
        buf.method_10804(this.books.size());
        for (var book : this.books.values()) {
            buf.method_10812(book.getId());
            book.toNetwork(buf);

            buf.method_10804(book.getCategories().size());
            for (var category : book.getCategories().values()) {
                buf.method_10812(category.getId());
                category.toNetwork(buf);

                buf.method_10804(category.getEntries().size());
                for (var entry : category.getEntries().values()) {
                    buf.method_10812(entry.getType());
                    entry.toNetwork(buf);
                }
            }

            buf.method_10804(book.getCommands().size());
            for (var command : book.getCommands().values()) {
                buf.method_10812(command.getId());
                command.toNetwork(buf);
            }
        }
    }

    private void decode(class_9129 buf) {
        //build books
        int bookCount = buf.method_10816();
        for (int i = 0; i < bookCount; i++) {
            class_2960 bookId = buf.method_10810();
            Book book = Book.fromNetwork(bookId, buf);
            this.books.put(bookId, book);

            int categoryCount = buf.method_10816();
            for (int j = 0; j < categoryCount; j++) {
                class_2960 categoryId = buf.method_10810();
                BookCategory category = BookCategory.fromNetwork(categoryId, buf);

                //link category and book
                book.addCategory(category);

                int entryCount = buf.method_10816();
                for (int k = 0; k < entryCount; k++) {
                    class_2960 entryTypeId = buf.method_10810();
                    BookEntry entry = LoaderRegistry.getEntryNetworkLoader(entryTypeId).fromNetwork(buf);

                    //link entry and category
                    category.addEntry(entry);
                }
            }

            int commandCount = buf.method_10816();
            for (int j = 0; j < commandCount; j++) {
                class_2960 commandId = buf.method_10810();
                BookCommand command = BookCommand.fromNetwork(commandId, buf);

                //link command and book
                book.addCommand(command);
            }
        }
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onClientReceived(class_310 minecraft, class_1657 player) {
        BookDataManager.get().registries(player.method_56673());
        BookDataManager.get().onDatapackSyncPacket(this);
    }
}
