/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class SyncMultiblockDataMessage implements Message {


    public static final class_9154<SyncMultiblockDataMessage> TYPE = new class_9154<>(class_2960.method_60655(Modonomicon.MOD_ID, "sync_multiblock_data"));
    public static final class_9139<class_9129, SyncMultiblockDataMessage> STREAM_CODEC = class_8710.method_56484(SyncMultiblockDataMessage::encode, SyncMultiblockDataMessage::new);

    public Map<class_2960, Multiblock> multiblocks = new Object2ObjectOpenHashMap<>();

    public SyncMultiblockDataMessage(Map<class_2960, Multiblock> multiblocks) {
        this.multiblocks = new Object2ObjectOpenHashMap<>(multiblocks);
    }

    public SyncMultiblockDataMessage(class_9129 buf) {
        this.decode(buf);
    }

    private void encode(class_9129 buf) {
        buf.method_10804(this.multiblocks.size());
        for (var multiblock : this.multiblocks.values()) {
            buf.method_10812(multiblock.getType());
            buf.method_10812(multiblock.getId());
            multiblock.toNetwork(buf);
        }
    }

    private void decode(class_9129 buf) {
        int multiblockCount = buf.method_10816();
        for (int i = 0; i < multiblockCount; i++) {
            var type = buf.method_10810();
            var id = buf.method_10810();
            var multiblock = LoaderRegistry.getMultiblockNetworkLoader(type).fromNetwork(buf);
            multiblock.setId(id);
            this.multiblocks.put(multiblock.getId(), multiblock);
        }
    }


    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void onClientReceived(class_310 minecraft, class_1657 player) {
        MultiblockDataManager.get().registries(player.method_56673());
        MultiblockDataManager.get().onDatapackSyncPacket(this);
    }
}
