/*
 * SPDX-FileCopyrightText: 2023 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.registry;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class FabricRegistrationFactory implements RegistrationProvider.Factory {

    @Override
    public <T> RegistrationProvider<T> create(class_5321<? extends class_2378<T>> resourceKey, String modId) {
        return new Provider<>(modId, resourceKey);
    }

    @Override
    public <T> RegistrationProvider<T> create(class_2378<T> registry, String modId) {
        return new Provider<>(modId, registry);
    }

    private static class Provider<T> implements RegistrationProvider<T> {
        private final String modId;
        private final class_2378<T> registry;

        private final Set<RegistryObject<T>> entries = new ObjectOpenHashSet<>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        @SuppressWarnings({"unchecked"})
        private Provider(String modId, class_5321<? extends class_2378<T>> key) {
            this.modId = modId;

            final var reg = class_7923.field_41167.method_63535(key.method_29177());

            if (reg == null) {
                throw new RuntimeException("Registry with name " + key.method_29177() + " was not found!");
            }
            this.registry = (class_2378<T>) reg;
        }

        private Provider(String modId, class_2378<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        @SuppressWarnings("unchecked")
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final var rl = class_2960.method_60655(this.modId, name);
            final var obj = class_2378.method_10230(this.registry, rl, supplier.get());
            final var ro = new RegistryObject<I>() {
                final class_5321<I> key = class_5321.method_29179((class_5321<? extends class_2378<I>>) Provider.this.registry.method_46765(), rl);

                @Override
                public class_5321<I> getResourceKey() {
                    return this.key;
                }

                @Override
                public class_2960 getId() {
                    return rl;
                }

                @Override
                public I get() {
                    return obj;
                }

                @Override
                public class_6880<I> asHolder() {
                    return (class_6880<I>) Provider.this.registry.method_46746((class_5321<T>) this.key).orElseThrow();
                }
            };
            this.entries.add((RegistryObject<T>) ro);
            return ro;
        }

        @Override
        public Collection<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }
}