/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.registry;

import com.klikli_dev.modonomicon.Modonomicon;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7924;

public class SoundRegistry {
    public static final RegistrationProvider<class_3414> SOUNDS = RegistrationProvider.get(class_7924.field_41225, Modonomicon.MOD_ID);

    public static final RegistryObject<class_3414> TURN_PAGE = SOUNDS.register("turn_page", () -> loadSoundEvent("turn_page"));

    /**
     * Creates the sound event object for the given sound event name, as specified in sounds.json Automatically appends
     * MODID.
     *
     * @param name the sound event name without domain.
     * @return the sound event.
     */
    private static class_3414 loadSoundEvent(String name) {
        class_2960 location = class_2960.method_60655(Modonomicon.MOD_ID, name);
        return class_3414.method_47908(location);
    }

    // Called in the mod initializer / constructor in order to make sure that items are registered
    public static void load() {
    }
}
