/*
 * SPDX-FileCopyrightText: 2022 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.util;

import com.klikli_dev.modonomicon.Modonomicon;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import org.apache.commons.lang3.tuple.Pair;

import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_7923;

public class EntityUtil {

    private static Pair<String, String> splitNameAndNBT(String entityId) {
        int nbtStart = entityId.indexOf("{");
        String nbtStr = "";
        if (nbtStart > 0) {
            nbtStr = entityId.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
            entityId = entityId.substring(0, nbtStart);
        }

        return Pair.of(entityId, nbtStr);
    }

    public static String getEntityName(String entityId) {
        Pair<String, String> nameAndNbt = splitNameAndNBT(entityId);
        var type = class_7923.field_41177.method_10223(class_2960.method_60654(nameAndNbt.getLeft()));

        return type.get().comp_349().method_5882();
    }

    public static Function<class_1937, class_1297> getEntityLoader(String entityId) {
        Pair<String, String> nameAndNbt = splitNameAndNBT(entityId);
        entityId = nameAndNbt.getLeft();
        String nbtStr = nameAndNbt.getRight();
        class_2487 nbt = null;

        if (!nbtStr.isEmpty()) {
            try {
                nbt = class_2522.method_67315(nbtStr);
            } catch (CommandSyntaxException e) {
                Modonomicon.LOG.error("Failed to load entity data", e);
            }
        }

        class_2960 key = class_2960.method_60654(entityId);
        var type = class_7923.field_41177.method_10223(key);
        if (type.isEmpty()) {
            throw new RuntimeException("Unknown entity id: " + entityId);
        }

        final class_2487 useNbt = nbt;
        final String useId = entityId;
        return (world) -> {
            class_1297 entity;
            try {
                entity = type.get().comp_349().method_5883(world, class_3730.field_52444);
                if (useNbt != null) {
                    entity.method_5651(useNbt);
                }

                return entity;
            } catch (Exception e) {
                throw new IllegalArgumentException("Can't load entity " + useId, e);
            }
        };
    }
}
