/*
 * SPDX-FileCopyrightText: 2023 klikli-dev
 *
 * SPDX-License-Identifier: MIT
 */

package com.klikli_dev.modonomicon.util;

import org.jetbrains.annotations.Nullable;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5481;

public class GuiGraphicsExt {


    /**
     * drawString for rendering at float coordinates.
     */
    public static int drawString(class_332 guiGraphics, class_327 font, @Nullable class_2561 component, float x, float y, int color, boolean drawShadow) {
        if (component == null) {
            return 0;
        } else {
            AtomicInteger i = new AtomicInteger();
            guiGraphics.method_64039(bufferSource -> {
                i.set(font.method_27522(component, x, y, color, drawShadow, guiGraphics.method_51448().method_23760().method_23761(), bufferSource, class_327.class_6415.field_33993, 0, 15728880));
            });
            return i.get();
        }
    }

    /**
     * drawString for rendering at float coordinates.
     */
    public static int drawString(class_332 guiGraphics, class_327 font, @Nullable String string, float x, float y, int color, boolean drawShadow) {
        if (string == null) {
            return 0;
        } else {
            AtomicInteger i = new AtomicInteger();
            guiGraphics.method_64039(bufferSource -> {
                i.set(font.method_27521(string, x, y, color, drawShadow, guiGraphics.method_51448().method_23760().method_23761(), bufferSource, class_327.class_6415.field_33993, 0, 15728880));
            });
            return i.get();
        }
    }

    /**
     * drawString for rendering at float coordinates.
     */
    public static int drawString(class_332 guiGraphics, class_327 font, @Nullable class_5481 string, float x, float y, int color, boolean drawShadow) {
        if (string == null) {
            return 0;
        } else {
            AtomicInteger i = new AtomicInteger();
            guiGraphics.method_64039(bufferSource -> {
                i.set(font.method_22942(string, x, y, color, drawShadow, guiGraphics.method_51448().method_23760().method_23761(), bufferSource, class_327.class_6415.field_33993, 0, 15728880));
            });
            return i.get();
        }
    }


    /**
     * Draws a textured box of any size (smallest size is borderSize * 2 square)
     * based on a fixed size textured box with continuous borders and filler.
     * See Forge IForgeGuiGraphics
     *
     * @param texture       the ResourceLocation object that contains the desired image
     * @param function      the render type function
     * @param x             x-axis offset
     * @param y             y-axis offset
     * @param u             bound resource location image x offset
     * @param v             bound resource location image y offset
     * @param width         the desired box width
     * @param height        the desired box height
     * @param textureWidth  the width of the box texture in the resource location image
     * @param textureHeight the height of the box texture in the resource location image
     * @param borderSize    the size of the box's borders
     */
    public static void blitWithBorder(class_332 guiGraphics, Function<class_2960, class_1921> function, class_2960 texture, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int borderSize) {
        blitWithBorder(guiGraphics, function, texture, x, y, u, v, width, height, textureWidth, textureHeight, borderSize, borderSize, borderSize, borderSize);
    }

    /**
     * Draws a textured box of any size (smallest size is borderSize * 2 square)
     * based on a fixed size textured box with continuous borders and filler.
     * See Forge IForgeGuiGraphics
     *
     * @param texture       the ResourceLocation object that contains the desired image
     * @param function      the render type function
     * @param x             x-axis offset
     * @param y             y-axis offset
     * @param u             bound resource location image x offset
     * @param v             bound resource location image y offset
     * @param width         the desired box width
     * @param height        the desired box height
     * @param maxU          the width of the box texture in the resource location image
     * @param maxV          the height of the box texture in the resource location image
     * @param topBorder     the size of the box's top border
     * @param bottomBorder  the size of the box's bottom border
     * @param leftBorder    the size of the box's left border
     * @param rightBorder   the size of the box's right border
     */
    public static void blitWithBorder(class_332 guiGraphics, Function<class_2960, class_1921> function, class_2960 texture, int x, int y, int u, int v, int width, int height, int maxU, int maxV, int topBorder, int bottomBorder, int leftBorder, int rightBorder) {
        int fillerWidth = maxU - leftBorder - rightBorder;
        int fillerHeight = maxV - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;

        // Draw Border
        // Top Left
        guiGraphics.method_25290(function, texture, x, y, u, v, leftBorder, topBorder, 256, 256);
        // Top Right
        guiGraphics.method_25290(function, texture, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, 256, 256);
        // Bottom Left
        guiGraphics.method_25290(function, texture, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, 256, 256);
        // Bottom Right
        guiGraphics.method_25290(function, texture, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, 256, 256);

        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); i++) {
            // Top Border
            guiGraphics.method_25290(function, texture, x + leftBorder + (i * fillerWidth), y, u + leftBorder, v, (i == xPasses ? remainderWidth : fillerWidth), topBorder, 256, 256);
            // Bottom Border
            guiGraphics.method_25290(function, texture, x + leftBorder + (i * fillerWidth), y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, (i == xPasses ? remainderWidth : fillerWidth), bottomBorder, 256, 256);

            // Throw in some filler for good measure
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); j++)
                guiGraphics.method_25290(function, texture, x + leftBorder + (i * fillerWidth), y + topBorder + (j * fillerHeight), u + leftBorder, v + topBorder, (i == xPasses ? remainderWidth : fillerWidth), (j == yPasses ? remainderHeight : fillerHeight), 256, 256);
        }

        // Side Borders
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); j++) {
            // Left Border
            guiGraphics.method_25290(function, texture, x, y + topBorder + (j * fillerHeight), u, v + topBorder, leftBorder, (j == yPasses ? remainderHeight : fillerHeight), 256, 256);
            // Right Border
            guiGraphics.method_25290(function, texture, x + leftBorder + canvasWidth, y + topBorder + (j * fillerHeight), u + leftBorder + fillerWidth, v + topBorder, rightBorder, (j == yPasses ? remainderHeight : fillerHeight), 256, 256);
        }
    }

}
