/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sodiumextrainformation.mixin;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import me.flashyreese.mods.sodiumextra.client.gui.SodiumExtraHud;
import net.anvian.sodiumextrainformation.client.SodiumExtraInformationClientMod;
import net.anvian.sodiumextrainformation.options.SodiumExtraInformationGameOptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SodiumExtraHud.class})
public class SodiumExtraHudMixin {
    @Final
    @Shadow
    private List<Component> textList;

    @Inject(method={"onStartTick"}, at={@At(value="RETURN")})
    private void inject(Minecraft client, CallbackInfo ci) {
        SodiumExtraInformationGameOptions options = SodiumExtraInformationClientMod.options();
        this.sodiumextrainformation$displayLocalTime(options);
        this.sodiumextrainformation$displayWorldTime(client, options);
        this.sodiumextrainformation$displaySessionTime(options);
        this.sodiumextrainformation$displayMemoryUsage(options);
        this.sodiumextrainformation$displayTotalEntityCount(client, options);
        this.sodiumextrainformation$displayRenderedEntities(client, options);
        this.sodiumextrainformation$displayBiome(client, options);
    }

    @Unique
    private void sodiumextrainformation$displayLocalTime(SodiumExtraInformationGameOptions options) {
        if (options.extraInformationSettings.localTimeConfig.showLocalTime) {
            LocalDateTime now = LocalDateTime.now();
            String timeFormat = options.extraInformationSettings.localTimeConfig.localTimeFormat;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(timeFormat);
            String formattedNow = now.format(formatter);
            this.textList.add((Component)Component.literal((String)formattedNow).withColor(options.extraInformationSettings.localTimeConfig.color.rgbToDecimal()));
        }
    }

    @Unique
    private void sodiumextrainformation$displayWorldTime(Minecraft client, SodiumExtraInformationGameOptions options) {
        if (!options.extraInformationSettings.wordTimeConfig.showWordTime || client.level == null) {
            return;
        }
        long worldTime = client.level.getDayTime();
        long currentDay = worldTime / 24000L;
        this.textList.add((Component)Component.translatable((String)"sodium-extra-information.hud.word_time").append(": ").append(String.valueOf(currentDay)).withColor(options.extraInformationSettings.wordTimeConfig.color.rgbToDecimal()));
    }

    @Unique
    private void sodiumextrainformation$displaySessionTime(SodiumExtraInformationGameOptions options) {
        if (options.extraInformationSettings.sessionTimeConfig.showSessionTime) {
            long totalTimePlayed = SodiumExtraInformationClientMod.getTotalTimePlayed();
            int hours = (int)(totalTimePlayed / 3600L);
            int minutes = (int)(totalTimePlayed % 3600L / 60L);
            int seconds = (int)(totalTimePlayed % 60L);
            this.textList.add((Component)Component.literal((String)(hours + "h " + minutes + "m " + seconds + "s")).withColor(options.extraInformationSettings.sessionTimeConfig.color.rgbToDecimal()));
        }
    }

    @Unique
    private void sodiumextrainformation$displayMemoryUsage(SodiumExtraInformationGameOptions options) {
        if (!options.extraInformationSettings.memoryUsageConfig.showMemoryUsage) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        int color = options.extraInformationSettings.memoryUsageConfig.color.rgbToDecimal();
        int memoryUsagePercent = (int)((double)usedMemory / (double)maxMemory * 100.0);
        this.textList.add((Component)Component.literal((String)(memoryUsagePercent + "%")).withColor(color));
        if (options.extraInformationSettings.memoryUsageConfig.showMemoryUsageExtended) {
            long usedMemoryMB = usedMemory / 0x100000L;
            long maxMemoryMB = maxMemory / 0x100000L;
            this.textList.add((Component)Component.literal((String)(usedMemoryMB + "MB / " + maxMemoryMB + "MB")).withColor(color));
        }
    }

    @Unique
    private void sodiumextrainformation$displayTotalEntityCount(Minecraft client, SodiumExtraInformationGameOptions options) {
        if (!options.extraInformationSettings.totalEntityCountConfig.showTotalEntityCount || client.level == null) {
            return;
        }
        this.textList.add((Component)Component.translatable((String)"sodium-extra-information.hud.show_total_entity_count").append(": ").append(String.valueOf(client.level.getEntityCount())).withColor(options.extraInformationSettings.totalEntityCountConfig.color.rgbToDecimal()));
    }

    @Unique
    private void sodiumextrainformation$displayRenderedEntities(Minecraft client, SodiumExtraInformationGameOptions options) {
        if (!options.extraInformationSettings.renderedEntitiesConfig.showsRenderedEntities || client.level == null) {
            return;
        }
        this.textList.add((Component)Component.translatable((String)"sodium-extra-information.hud.shows_rendered_entities").append(": ").append(String.valueOf(client.levelRenderer.renderedEntities)).withColor(options.extraInformationSettings.renderedEntitiesConfig.color.rgbToDecimal()));
    }

    @Unique
    private void sodiumextrainformation$displayBiome(Minecraft client, SodiumExtraInformationGameOptions options) {
        if (!options.extraInformationSettings.biomeConfig.showBiome || client.level == null || client.player == null) {
            return;
        }
        ClientLevel level = client.level;
        BlockPos playerPos = client.player.blockPosition();
        Biome biome = (Biome)level.getBiome(playerPos).value();
        String biomeName = level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome).toString();
        MutableComponent txt = biomeName.startsWith("minecraft:") ? Component.translatable((String)("biome.minecraft." + biomeName.substring("minecraft:".length()))) : Component.literal((String)biomeName);
        this.textList.add((Component)txt.withColor(options.extraInformationSettings.biomeConfig.color.rgbToDecimal()));
    }
}

