/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sodiumextrainformation.options;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import net.anvian.sodiumextrainformation.util.RGB;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;

public class SodiumExtraInformationGameOptions {
    public final ExtraInformationSettings extraInformationSettings = new ExtraInformationSettings();
    private static final String DEFAULT_FILE_NAME = "sodiumextrainformation.json";
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    private Path configPath;

    public static SodiumExtraInformationGameOptions load() {
        SodiumExtraInformationGameOptions config;
        Path path;
        block11: {
            path = PlatformRuntimeInformation.getInstance().getConfigDirectory().resolve("sodiumextrainformation").resolve(DEFAULT_FILE_NAME);
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (SodiumExtraInformationGameOptions)GSON.fromJson((Reader)reader, SodiumExtraInformationGameOptions.class);
                    break block11;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse SSPB config", e);
                }
            }
            config = new SodiumExtraInformationGameOptions();
        }
        config.configPath = path;
        if (!config.extraInformationSettings.localTimeConfig.validateTimeFormat(config.extraInformationSettings.localTimeConfig.localTimeFormat)) {
            config.extraInformationSettings.localTimeConfig.localTimeFormat = "HH:mm:ss";
        }
        try {
            config.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update SSPB config", e);
        }
        return config;
    }

    public void writeChanges() throws IOException {
        Path dir = this.configPath.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + String.valueOf(dir));
        }
        Files.writeString(this.configPath, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
    }

    public static class ExtraInformationSettings {
        public LocalTimeConfig localTimeConfig = new LocalTimeConfig();
        public WordTimeConfig wordTimeConfig = new WordTimeConfig();
        public SessionTimeConfig sessionTimeConfig = new SessionTimeConfig();
        public MemoryUsageConfig memoryUsageConfig = new MemoryUsageConfig();
        public TotalEntityCountConfig totalEntityCountConfig = new TotalEntityCountConfig();
        public RenderedEntitiesConfig renderedEntitiesConfig = new RenderedEntitiesConfig();
        public BiomeConfig biomeConfig = new BiomeConfig();

        public static class LocalTimeConfig {
            public boolean showLocalTime = false;
            public String localTimeFormat = "HH:mm";
            public RGB color = new RGB();

            private boolean validateTimeFormat(String format) {
                try {
                    DateTimeFormatter.ofPattern(format);
                    return true;
                }
                catch (IllegalArgumentException | DateTimeParseException e) {
                    return false;
                }
            }
        }

        public static class WordTimeConfig {
            public boolean showWordTime = false;
            public RGB color = new RGB();
        }

        public static class SessionTimeConfig {
            public boolean showSessionTime = false;
            public RGB color = new RGB();
        }

        public static class MemoryUsageConfig {
            public boolean showMemoryUsage = false;
            public boolean showMemoryUsageExtended = false;
            public RGB color = new RGB();
        }

        public static class TotalEntityCountConfig {
            public boolean showTotalEntityCount = false;
            public RGB color = new RGB();
        }

        public static class RenderedEntitiesConfig {
            public boolean showsRenderedEntities = false;
            public RGB color = new RGB();
        }

        public static class BiomeConfig {
            public boolean showBiome = false;
            public RGB color = new RGB();
        }
    }
}

