/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sodiumextrainformation.mixin;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import me.flashyreese.mods.sodiumextra.client.gui.SodiumExtraHud;
import net.anvian.sodiumextrainformation.client.SodiumExtraInformationClientMod;
import net.anvian.sodiumextrainformation.options.SodiumExtraInformationGameOptions;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SodiumExtraHud.class})
public class SodiumExtraHudMixin {
    @Final
    @Shadow
    private List<class_2561> textList;

    @Inject(method={"onStartTick"}, at={@At(value="RETURN")})
    private void inject(class_310 client, CallbackInfo ci) {
        SodiumExtraInformationGameOptions options = SodiumExtraInformationClientMod.options();
        this.sodiumextrainformation$displayLocalTime(options);
        this.sodiumextrainformation$displayWorldTime(client, options);
        this.sodiumextrainformation$displaySessionTime(options);
        this.sodiumextrainformation$displayMemoryUsage(options);
        this.sodiumextrainformation$displayTotalEntityCount(client, options);
        this.sodiumextrainformation$displayRenderedEntities(client, options);
        this.sodiumextrainformation$displayBiome(client, options);
    }

    @Unique
    private void sodiumextrainformation$displayLocalTime(SodiumExtraInformationGameOptions options) {
        if (options.extraInformationSettings.localTimeConfig.showLocalTime) {
            LocalDateTime now = LocalDateTime.now();
            String timeFormat = options.extraInformationSettings.localTimeConfig.localTimeFormat;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(timeFormat);
            String formattedNow = now.format(formatter);
            this.textList.add((class_2561)class_2561.method_43470((String)formattedNow).method_54663(options.extraInformationSettings.localTimeConfig.color.rgbToDecimal()));
        }
    }

    @Unique
    private void sodiumextrainformation$displayWorldTime(class_310 client, SodiumExtraInformationGameOptions options) {
        if (!options.extraInformationSettings.wordTimeConfig.showWordTime || client.field_1687 == null) {
            return;
        }
        long worldTime = client.field_1687.method_8532();
        long currentDay = worldTime / 24000L;
        this.textList.add((class_2561)class_2561.method_43471((String)"sodium-extra-information.hud.word_time").method_27693(": ").method_27693(String.valueOf(currentDay)).method_54663(options.extraInformationSettings.wordTimeConfig.color.rgbToDecimal()));
    }

    @Unique
    private void sodiumextrainformation$displaySessionTime(SodiumExtraInformationGameOptions options) {
        if (options.extraInformationSettings.sessionTimeConfig.showSessionTime) {
            long totalTimePlayed = SodiumExtraInformationClientMod.getTotalTimePlayed();
            int hours = (int)(totalTimePlayed / 3600L);
            int minutes = (int)(totalTimePlayed % 3600L / 60L);
            int seconds = (int)(totalTimePlayed % 60L);
            this.textList.add((class_2561)class_2561.method_43470((String)(hours + "h " + minutes + "m " + seconds + "s")).method_54663(options.extraInformationSettings.sessionTimeConfig.color.rgbToDecimal()));
        }
    }

    @Unique
    private void sodiumextrainformation$displayMemoryUsage(SodiumExtraInformationGameOptions options) {
        if (!options.extraInformationSettings.memoryUsageConfig.showMemoryUsage) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        int color = options.extraInformationSettings.memoryUsageConfig.color.rgbToDecimal();
        int memoryUsagePercent = (int)((double)usedMemory / (double)maxMemory * 100.0);
        this.textList.add((class_2561)class_2561.method_43470((String)(memoryUsagePercent + "%")).method_54663(color));
        if (options.extraInformationSettings.memoryUsageConfig.showMemoryUsageExtended) {
            long usedMemoryMB = usedMemory / 0x100000L;
            long maxMemoryMB = maxMemory / 0x100000L;
            this.textList.add((class_2561)class_2561.method_43470((String)(usedMemoryMB + "MB / " + maxMemoryMB + "MB")).method_54663(color));
        }
    }

    @Unique
    private void sodiumextrainformation$displayTotalEntityCount(class_310 client, SodiumExtraInformationGameOptions options) {
        if (!options.extraInformationSettings.totalEntityCountConfig.showTotalEntityCount || client.field_1687 == null) {
            return;
        }
        this.textList.add((class_2561)class_2561.method_43471((String)"sodium-extra-information.hud.show_total_entity_count").method_27693(": ").method_27693(String.valueOf(client.field_1687.method_18120())).method_54663(options.extraInformationSettings.totalEntityCountConfig.color.rgbToDecimal()));
    }

    @Unique
    private void sodiumextrainformation$displayRenderedEntities(class_310 client, SodiumExtraInformationGameOptions options) {
        if (!options.extraInformationSettings.renderedEntitiesConfig.showsRenderedEntities || client.field_1687 == null) {
            return;
        }
        this.textList.add((class_2561)class_2561.method_43471((String)"sodium-extra-information.hud.shows_rendered_entities").method_27693(": ").method_27693(String.valueOf(client.field_1769.field_4089)).method_54663(options.extraInformationSettings.renderedEntitiesConfig.color.rgbToDecimal()));
    }

    @Unique
    private void sodiumextrainformation$displayBiome(class_310 client, SodiumExtraInformationGameOptions options) {
        if (!options.extraInformationSettings.biomeConfig.showBiome || client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_638 level = client.field_1687;
        class_2338 playerPos = client.field_1724.method_24515();
        class_1959 biome = (class_1959)level.method_23753(playerPos).comp_349();
        String biomeName = level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome).toString();
        class_5250 txt = biomeName.startsWith("minecraft:") ? class_2561.method_43471((String)("biome.minecraft." + biomeName.substring("minecraft:".length()))) : class_2561.method_43470((String)biomeName);
        this.textList.add((class_2561)txt.method_54663(options.extraInformationSettings.biomeConfig.color.rgbToDecimal()));
    }
}

