/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.sodiumextrainformation.util;

import net.anvian.sodiumextrainformation.client.SodiumExtraInformationClientMod;
import org.slf4j.Logger;

public class SessionManager {
    private static final Logger LOGGER = SodiumExtraInformationClientMod.logger();
    private long sessionStartTime;
    private long totalTimePlayed;
    private boolean inSession;
    private boolean isPaused;

    public synchronized void startSession() {
        this.sessionStartTime = System.currentTimeMillis();
        this.inSession = true;
        this.isPaused = false;
        LOGGER.info("Session started");
    }

    public synchronized void endSession() {
        this.inSession = false;
        LOGGER.info("Session ended");
    }

    public synchronized void pauseSession() {
        this.isPaused = true;
        this.totalTimePlayed += System.currentTimeMillis() - this.sessionStartTime;
        LOGGER.info("Session paused");
    }

    public synchronized void resumeSession() {
        this.isPaused = false;
        this.sessionStartTime = System.currentTimeMillis();
        LOGGER.info("Session resumed");
    }

    public synchronized void updateSessionTime() {
        long currentTime = System.currentTimeMillis();
        this.totalTimePlayed += currentTime - this.sessionStartTime;
        this.sessionStartTime = currentTime;
    }

    public void resetSession() {
        this.sessionStartTime = 0L;
        this.totalTimePlayed = 0L;
        this.inSession = false;
        this.isPaused = false;
    }

    public boolean isInSession() {
        return this.inSession;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public long getTotalTimePlayed() {
        return this.totalTimePlayed / 1000L;
    }
}

