/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.annotation.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.oddlama.vane.annotation.config.ConfigBoolean", "org.oddlama.vane.annotation.config.ConfigDict", "org.oddlama.vane.annotation.config.ConfigDouble", "org.oddlama.vane.annotation.config.ConfigDoubleList", "org.oddlama.vane.annotation.config.ConfigExtendedMaterial", "org.oddlama.vane.annotation.config.ConfigInt", "org.oddlama.vane.annotation.config.ConfigIntList", "org.oddlama.vane.annotation.config.ConfigItemStack", "org.oddlama.vane.annotation.config.ConfigLong", "org.oddlama.vane.annotation.config.ConfigMaterial", "org.oddlama.vane.annotation.config.ConfigMaterialMapMapMap", "org.oddlama.vane.annotation.config.ConfigMaterialSet", "org.oddlama.vane.annotation.config.ConfigString", "org.oddlama.vane.annotation.config.ConfigStringList", "org.oddlama.vane.annotation.config.ConfigStringListMap", "org.oddlama.vane.annotation.config.ConfigVersion", "org.oddlama.vane.annotation.lang.LangMessage", "org.oddlama.vane.annotation.lang.LangMessageArray", "org.oddlama.vane.annotation.lang.LangVersion"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
public class ConfigAndLangProcessor
extends AbstractProcessor {
    private static final Map<String, String> field_type_mapping;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round_env) {
        for (TypeElement typeElement : annotations) {
            round_env.getElementsAnnotatedWith(typeElement).forEach(e -> this.verify_type(annotation, (Element)e));
        }
        return true;
    }

    private void verify_type(TypeElement annotation, Element element) {
        String type = element.asType().toString();
        String required_type = field_type_mapping.get(annotation.asType().toString());
        if (required_type == null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, element.asType().toString() + ": @" + String.valueOf(annotation.getSimpleName()) + " has no required_type mapping! This is a bug.");
        } else if (!required_type.equals("<any>") && !required_type.equals(type)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, element.asType().toString() + ": @" + String.valueOf(annotation.getSimpleName()) + " requires a field of type " + required_type + " but got " + type);
        }
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("org.oddlama.vane.annotation.config.ConfigBoolean", "boolean");
        map.put("org.oddlama.vane.annotation.config.ConfigDict", "<any>");
        map.put("org.oddlama.vane.annotation.config.ConfigDouble", "double");
        map.put("org.oddlama.vane.annotation.config.ConfigDoubleList", "java.util.List<java.lang.Double>");
        map.put("org.oddlama.vane.annotation.config.ConfigExtendedMaterial", "org.oddlama.vane.core.material.ExtendedMaterial");
        map.put("org.oddlama.vane.annotation.config.ConfigInt", "int");
        map.put("org.oddlama.vane.annotation.config.ConfigIntList", "java.util.List<java.lang.Integer>");
        map.put("org.oddlama.vane.annotation.config.ConfigItemStack", "org.bukkit.inventory.ItemStack");
        map.put("org.oddlama.vane.annotation.config.ConfigLong", "long");
        map.put("org.oddlama.vane.annotation.config.ConfigMaterial", "org.bukkit.Material");
        map.put("org.oddlama.vane.annotation.config.ConfigMaterialMapMapMap", "java.util.Map<java.lang.String,java.util.Map<java.lang.String,java.util.Map<java.lang.String,org.bukkit.Material>>>");
        map.put("org.oddlama.vane.annotation.config.ConfigMaterialSet", "java.util.Set<org.bukkit.Material>");
        map.put("org.oddlama.vane.annotation.config.ConfigString", "java.lang.String");
        map.put("org.oddlama.vane.annotation.config.ConfigStringList", "java.util.List<java.lang.String>");
        map.put("org.oddlama.vane.annotation.config.ConfigStringListMap", "java.util.Map<java.lang.String,java.util.List<java.lang.String>>");
        map.put("org.oddlama.vane.annotation.config.ConfigVersion", "long");
        map.put("org.oddlama.vane.annotation.lang.LangMessage", "org.oddlama.vane.core.lang.TranslatedMessage");
        map.put("org.oddlama.vane.annotation.lang.LangMessageArray", "org.oddlama.vane.core.lang.TranslatedMessageArray");
        map.put("org.oddlama.vane.annotation.lang.LangVersion", "long");
        field_type_mapping = Collections.unmodifiableMap(map);
    }
}

