/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.annotation.processor;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.oddlama.vane.annotation.VaneModule"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
public class VaneModuleProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round_env) {
        for (TypeElement typeElement : annotations) {
            round_env.getElementsAnnotatedWith(typeElement).forEach(this::verify_is_class);
            round_env.getElementsAnnotatedWith(typeElement).forEach(this::verify_extends_module);
        }
        return true;
    }

    private void verify_is_class(Element element) {
        if (element.getKind() != ElementKind.CLASS) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, element.asType().toString() + ": @VaneModule must be applied to a class");
        }
    }

    private void verify_extends_module(Element element) {
        TypeElement t = (TypeElement)element;
        while (true) {
            if (t.asType().toString().startsWith("org.oddlama.vane.core.module.Module<")) {
                return;
            }
            if (!(t.getSuperclass() instanceof DeclaredType)) break;
            t = (TypeElement)((DeclaredType)t.getSuperclass()).asElement();
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, element.asType().toString() + ": @VaneModule must be applied to a class inheriting from org.oddlama.vane.core.Module");
    }
}

