/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.oddlama.vane.annotation.VaneModule;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.commands.CustomItem;
import org.oddlama.vane.core.commands.Enchant;
import org.oddlama.vane.core.commands.Vane;
import org.oddlama.vane.core.enchantments.EnchantmentManager;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.item.CustomItemRegistry;
import org.oddlama.vane.core.item.CustomModelDataRegistry;
import org.oddlama.vane.core.item.DurabilityManager;
import org.oddlama.vane.core.item.ExistingItemConverter;
import org.oddlama.vane.core.item.VanillaFunctionalityInhibitor;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.menu.MenuManager;
import org.oddlama.vane.core.misc.AuthMultiplexer;
import org.oddlama.vane.core.misc.CommandHider;
import org.oddlama.vane.core.misc.HeadLibrary;
import org.oddlama.vane.core.misc.LootChestProtector;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.core.resourcepack.ResourcePackDistributor;
import org.oddlama.vane.core.resourcepack.ResourcePackGenerator;
import org.oddlama.vane.external.json.JSONException;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.util.Conversions;
import org.oddlama.vane.util.IOUtil;

@VaneModule(name="core", bstats=8637, config_version=6L, lang_version=4L, storage_version=1L)
public class Core
extends Module<Core> {
    private static Core INSTANCE = null;
    public EnchantmentManager enchantment_manager;
    private CustomModelDataRegistry model_data_registry;
    private CustomItemRegistry item_registry;
    @ConfigBoolean(def=true, desc="Allow loading of player heads in relevant menus. Disabling this will show all player heads using the Steve skin, which may perform better on low-performance servers and clients.")
    public boolean config_player_heads_in_menus;
    @LangMessage
    public TranslatedMessage lang_command_not_a_player;
    @LangMessage
    public TranslatedMessage lang_command_permission_denied;
    @LangMessage
    public TranslatedMessage lang_invalid_time_format;
    private SortedSet<Module<?>> vane_modules = new TreeSet((a, b) -> a.get_name().compareTo(b.get_name()));
    public final ResourcePackDistributor resource_pack_distributor;
    public Permission permission_command_catchall = new Permission("vane.*.commands.*", "Allow access to all vane commands (ONLY FOR ADMINS!)", PermissionDefault.FALSE);
    public MenuManager menu_manager;
    @ConfigBoolean(def=true, desc="Let the client translate messages using the generated resource pack. This allows every player to select their preferred language, and all plugin messages will also be translated. Disabling this won't allow you to skip generating the resource pack, as it will be needed for custom item textures.")
    public boolean config_client_side_translations;
    @ConfigBoolean(def=true, desc="Send update notices to OPed player when a new version of vane is available.")
    public boolean config_update_notices;
    public String current_version = null;
    public String latest_version = null;

    public static Core instance() {
        return INSTANCE;
    }

    public void register_module(Module<?> module) {
        this.vane_modules.add(module);
    }

    public void unregister_module(Module<?> module) {
        this.vane_modules.remove(module);
    }

    public SortedSet<Module<?>> get_modules() {
        return Collections.unmodifiableSortedSet(this.vane_modules);
    }

    public Core() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Cannot instanciate Core twice.");
        }
        INSTANCE = this;
        this.register_permission(this.permission_command_catchall);
        this.unfreeze_registries();
        this.enchantment_manager = new EnchantmentManager(this);
        new HeadLibrary(this);
        new AuthMultiplexer(this);
        new LootChestProtector(this);
        new VanillaFunctionalityInhibitor(this);
        new DurabilityManager(this);
        new Vane(this);
        new CustomItem(this);
        new Enchant(this);
        this.menu_manager = new MenuManager(this);
        this.resource_pack_distributor = new ResourcePackDistributor(this);
        new CommandHider(this);
        this.model_data_registry = new CustomModelDataRegistry();
        this.item_registry = new CustomItemRegistry();
        new ExistingItemConverter(this);
    }

    @Override
    public void on_enable() {
        if (this.config_update_notices) {
            this.schedule_task_timer(this::check_for_update, 1L, Conversions.ms_to_ticks(0x6DDD00L));
        }
    }

    public void unfreeze_registries() {
        try {
            Field frozen = MappedRegistry.class.getDeclaredField("frozen");
            frozen.setAccessible(true);
            Field intrusive_holder_cache = MappedRegistry.class.getDeclaredField("unregisteredIntrusiveHolders");
            intrusive_holder_cache.setAccessible(true);
            frozen.set(BuiltInRegistries.ENTITY_TYPE, false);
            intrusive_holder_cache.set(BuiltInRegistries.ENTITY_TYPE, new IdentityHashMap());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void on_disable() {
    }

    public File generate_resource_pack() {
        try {
            File file = new File("vane-resource-pack.zip");
            ResourcePackGenerator pack = new ResourcePackGenerator();
            for (Module module : this.vane_modules) {
                module.generate_resource_pack(pack);
            }
            pack.write(file);
            return file;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error while generating resourcepack", e);
            return null;
        }
    }

    public void for_all_module_components(Consumer1<ModuleComponent<?>> f) {
        for (Module module : this.vane_modules) {
            module.for_each_module_component(f);
        }
    }

    public CustomItemRegistry item_registry() {
        return this.item_registry;
    }

    public CustomModelDataRegistry model_data_registry() {
        return this.model_data_registry;
    }

    public void check_for_update() {
        if (this.current_version == null) {
            try {
                Properties properties = new Properties();
                properties.load(Core.class.getResourceAsStream("/vane-core.properties"));
                this.current_version = "v" + properties.getProperty("version");
            }
            catch (IOException e) {
                this.log.severe("Could not load current version from included properties file: " + String.valueOf(e));
                return;
            }
        }
        try {
            JSONObject json = IOUtil.read_json_from_url("https://api.github.com/repos/oddlama/vane/releases/latest");
            this.latest_version = json.getString("tag_name");
            if (this.latest_version != null && !this.latest_version.equals(this.current_version)) {
                this.log.warning("A newer version of vane is available online! (current=" + this.current_version + ", new=" + this.latest_version + ")");
                this.log.warning("Please update as soon as possible to get the latest features and fixes.");
                this.log.warning("Get the latest release here: https://github.com/oddlama/vane/releases/latest");
            }
        }
        catch (IOException | URISyntaxException | JSONException e) {
            this.log.warning("Could not check for updates: " + String.valueOf(e));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void on_player_join_send_update_notice(PlayerJoinEvent event) {
        if (!this.config_update_notices) {
            return;
        }
        if (this.latest_version != null && !this.latest_version.equals(this.current_version) && event.getPlayer().isOp()) {
            event.getPlayer().sendMessage(((TextComponent)Component.text((String)"A new version of vane ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)("(" + this.latest_version + ")"), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)" is available!", (TextColor)NamedTextColor.GREEN)));
            event.getPlayer().sendMessage((Component)Component.text((String)"Please update soon to get the latest features.", (TextColor)NamedTextColor.GREEN));
            event.getPlayer().sendMessage(Component.text((String)"Click here to go to the download page", (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.openUrl((String)"https://github.com/oddlama/vane/releases/latest")));
        }
    }
}

