/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.core.functional.Consumer2;

public class LootTable {
    private Map<NamespacedKey, List<LootTableEntry>> possible_loot = new HashMap<NamespacedKey, List<LootTableEntry>>();

    public LootTable put(NamespacedKey key, LootTableEntry entry) {
        this.possible_loot.put(key, List.of(entry));
        return this;
    }

    public LootTable put(NamespacedKey key, List<LootTableEntry> entries) {
        this.possible_loot.put(key, entries);
        return this;
    }

    public LootTable remove(NamespacedKey key) {
        this.possible_loot.remove(key);
        return this;
    }

    public Map<NamespacedKey, List<LootTableEntry>> possible_loot() {
        return this.possible_loot;
    }

    public List<LootTableEntry> flat_copy() {
        ArrayList<LootTableEntry> list = new ArrayList<LootTableEntry>();
        this.possible_loot.values().forEach(list::addAll);
        return list;
    }

    public void generate_loot(List<ItemStack> output, Random random) {
        for (List<LootTableEntry> set : this.possible_loot.values()) {
            for (LootTableEntry loot : set) {
                if (!loot.evaluate_chance(random)) continue;
                loot.add_sample(output, random);
            }
        }
    }

    public ItemStack generate_override(Random random) {
        double total_chance = 0.0;
        double threshold = random.nextDouble();
        ArrayList<ItemStack> result_container = new ArrayList<ItemStack>(1);
        List<LootTableEntry> loot_list = this.flat_copy();
        Collections.shuffle(loot_list, random);
        for (LootTableEntry loot : loot_list) {
            if ((total_chance += loot.chance) > threshold) {
                loot.add_sample(result_container, random);
            }
            if (result_container.isEmpty()) continue;
            return (ItemStack)result_container.get(0);
        }
        return null;
    }

    public static class LootTableEntry {
        public double chance;
        public Consumer2<List<ItemStack>, Random> generator;

        public LootTableEntry(int rarity_expected_chests, ItemStack item) {
            this(1.0 / (double)rarity_expected_chests, item.clone(), 1, 1);
        }

        public LootTableEntry(int rarity_expected_chests, ItemStack item, int amount_min, int amount_max) {
            this(1.0 / (double)rarity_expected_chests, item.clone(), amount_min, amount_max);
        }

        public LootTableEntry(double chance, ItemStack item, int amount_min, int amount_max) {
            this(chance, (List<ItemStack> list, Random random) -> {
                ItemStack i = item.clone();
                int amount = random.nextInt(amount_max - amount_min + 1) + amount_min;
                if (amount < 1) {
                    return;
                }
                i.setAmount(amount);
                list.add(i);
            });
        }

        public LootTableEntry(double chance, Consumer2<List<ItemStack>, Random> generator) {
            this.chance = chance;
            this.generator = generator;
        }

        public void add_sample(List<ItemStack> items, Random random) {
            this.generator.apply(items, random);
        }

        public boolean evaluate_chance(Random random) {
            return random.nextDouble() < this.chance;
        }
    }
}

