/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.oddlama.vane.annotation.command.Aliases;
import org.oddlama.vane.annotation.command.Name;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.command.Param;
import org.oddlama.vane.core.command.params.AnyParam;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.module.ModuleComponent;
import org.oddlama.vane.util.ArrayUtil;

public abstract class Command<T extends Module<T>>
extends ModuleComponent<T> {
    @LangMessage
    public TranslatedMessage lang_usage;
    @LangMessage
    public TranslatedMessage lang_description;
    @LangMessage
    public TranslatedMessage lang_help;
    private String name = this.getClass().getAnnotation(Name.class).value();
    private Permission permission;
    private BukkitCommand bukkit_command;
    private AnyParam<String> root_param;
    private LiteralArgumentBuilder<CommandSourceStack> brigadier_command;
    private Aliases aliases;

    public Command(Context<T> context) {
        this(context, PermissionDefault.OP);
    }

    public Command(Context<T> context, PermissionDefault permission_default) {
        super(null);
        context = context.group("command_" + this.name, "Enable command " + this.name);
        this.set_context(context);
        this.permission = new Permission("vane." + ((Module)this.get_module()).get_name() + ".commands." + this.name, "Allow access to /" + this.name, permission_default);
        ((Module)this.get_module()).register_permission(this.permission);
        this.permission.addParent(((Module)this.get_module()).permission_command_catchall_module, true);
        this.permission.addParent(((Module)this.get_module()).core.permission_command_catchall, true);
        ((Module)this.get_module()).add_console_permission(this.permission);
        this.root_param = new AnyParam<String>(this, "/" + this.get_name(), str -> str);
        this.bukkit_command = new BukkitCommand(this.name);
        this.bukkit_command.setLabel(this.name);
        this.bukkit_command.setName(this.name);
        this.aliases = this.getClass().getAnnotation(Aliases.class);
        this.brigadier_command = Commands.literal((String)this.name);
        if (this.aliases != null) {
            this.bukkit_command.setAliases(List.of(this.aliases.value()));
        }
    }

    public BukkitCommand get_bukkit_command() {
        return this.bukkit_command;
    }

    public String get_name() {
        return this.name;
    }

    public String get_permission() {
        return this.permission.getName();
    }

    public String get_prefix() {
        return "vane:" + ((Module)this.get_module()).get_name();
    }

    public Param params() {
        return this.root_param;
    }

    public LiteralArgumentBuilder<CommandSourceStack> get_command_base() {
        return this.brigadier_command;
    }

    public LiteralCommandNode<CommandSourceStack> get_command() {
        LiteralArgumentBuilder<CommandSourceStack> cmd = this.get_command_base();
        Predicate old_requirement = cmd.getRequirement();
        return ((LiteralArgumentBuilder)cmd.requires(stack -> stack.getSender().hasPermission(this.permission) && old_requirement.test(stack))).build();
    }

    public List<String> get_aliases() {
        if (this.aliases != null && this.aliases.value().length > 0) {
            return List.of(this.aliases.value());
        }
        return Collections.emptyList();
    }

    @Override
    protected void on_enable() {
        ((Module)this.get_module()).register_command(this);
    }

    @Override
    protected void on_disable() {
        ((Module)this.get_module()).unregister_command(this);
    }

    public void print_help(CommandSender sender) {
        this.lang_usage.send(sender, "\u00a77/\u00a73" + this.name);
        this.lang_help.send(sender, new Object[0]);
    }

    public int print_help2(CommandContext<CommandSourceStack> ctx) {
        this.lang_usage.send(((CommandSourceStack)ctx.getSource()).getSender(), "\u00a77/\u00a73" + this.name);
        this.lang_help.send(((CommandSourceStack)ctx.getSource()).getSender(), new Object[0]);
        return 1;
    }

    public LiteralArgumentBuilder<CommandSourceStack> help() {
        return (LiteralArgumentBuilder)Commands.literal((String)"help").executes(ctx -> {
            this.print_help2((CommandContext<CommandSourceStack>)ctx);
            return 1;
        });
    }

    public class BukkitCommand
    extends org.bukkit.command.Command
    implements PluginIdentifiableCommand {
        public BukkitCommand(String name) {
            super(name);
            this.setPermission(Command.this.permission.getName());
        }

        public String getUsage() {
            return Command.this.lang_usage.str("\u00a77/\u00a73" + Command.this.name);
        }

        public String getDescription() {
            return Command.this.lang_description.str(new Object[0]);
        }

        public Plugin getPlugin() {
            return Command.this.get_module();
        }

        public boolean execute(CommandSender sender, String alias, String[] args) {
            System.out.println("exec " + alias + " from " + String.valueOf(sender));
            if (!sender.hasPermission(Command.this.permission)) {
                ((Module)Command.this.get_module()).core.lang_command_permission_denied.send(sender, new Object[0]);
                System.out.println("no perms!");
                return true;
            }
            try {
                return Command.this.root_param.check_accept(sender, ArrayUtil.prepend(args, alias), 0).apply(Command.this, sender);
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7cAn unexpected error occurred. Please examine the console log and/or notify a server administrator.");
                throw e;
            }
        }

        public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
            if (!sender.hasPermission(this.getPermission())) {
                return Collections.emptyList();
            }
            try {
                return Command.this.root_param.build_completions(sender, ArrayUtil.prepend(args, alias), 0);
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7cAn unexpected error occurred. Please examine the console log and/or notify a server administrator.");
                throw e;
            }
        }
    }
}

