/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.command;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.command.check.CheckResult;
import org.oddlama.vane.core.command.check.CombinedErrorCheckResult;
import org.oddlama.vane.core.command.check.ErrorCheckResult;
import org.oddlama.vane.core.command.check.ParseCheckResult;
import org.oddlama.vane.core.command.params.AnyParam;
import org.oddlama.vane.core.command.params.ChoiceParam;
import org.oddlama.vane.core.command.params.DynamicChoiceParam;
import org.oddlama.vane.core.command.params.FixedParam;
import org.oddlama.vane.core.command.params.SentinelExecutorParam;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Consumer2;
import org.oddlama.vane.core.functional.Consumer3;
import org.oddlama.vane.core.functional.Consumer4;
import org.oddlama.vane.core.functional.Consumer5;
import org.oddlama.vane.core.functional.Consumer6;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.functional.Function3;
import org.oddlama.vane.core.functional.Function4;
import org.oddlama.vane.core.functional.Function5;
import org.oddlama.vane.core.functional.Function6;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.util.StorageUtil;

public interface Param {
    public List<Param> get_params();

    default public boolean require_player(CommandSender sender) {
        if (!(sender instanceof Player)) {
            ((Module)this.get_command().get_module()).core.lang_command_not_a_player.send(sender, new Object[0]);
            return false;
        }
        return true;
    }

    default public boolean is_executor() {
        return false;
    }

    default public void add_param(Param param) {
        if (param.is_executor() && this.get_params().stream().anyMatch(p -> p.is_executor())) {
            throw new RuntimeException("Cannot define multiple executors for the same parameter! This is a bug.");
        }
        this.get_params().add(param);
    }

    default public <T1> void exec_player(Consumer1<T1> f) {
        this.add_param(new SentinelExecutorParam<Consumer1<T1>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1, T2> void exec_player(Consumer2<T1, T2> f) {
        this.add_param(new SentinelExecutorParam<Consumer2<T1, T2>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1, T2, T3> void exec_player(Consumer3<T1, T2, T3> f) {
        this.add_param(new SentinelExecutorParam<Consumer3<T1, T2, T3>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1, T2, T3, T4> void exec_player(Consumer4<T1, T2, T3, T4> f) {
        this.add_param(new SentinelExecutorParam<Consumer4<T1, T2, T3, T4>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1, T2, T3, T4, T5> void exec_player(Consumer5<T1, T2, T3, T4, T5> f) {
        this.add_param(new SentinelExecutorParam<Consumer5<T1, T2, T3, T4, T5>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1, T2, T3, T4, T5, T6> void exec_player(Consumer6<T1, T2, T3, T4, T5, T6> f) {
        this.add_param(new SentinelExecutorParam<Consumer6<T1, T2, T3, T4, T5, T6>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1> void exec_player(Function1<T1, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function1<T1, Boolean>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1, T2> void exec_player(Function2<T1, T2, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function2<T1, T2, Boolean>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1, T2, T3> void exec_player(Function3<T1, T2, T3, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function3<T1, T2, T3, Boolean>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1, T2, T3, T4> void exec_player(Function4<T1, T2, T3, T4, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function4<T1, T2, T3, T4, Boolean>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1, T2, T3, T4, T5> void exec_player(Function5<T1, T2, T3, T4, T5, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function5<T1, T2, T3, T4, T5, Boolean>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1, T2, T3, T4, T5, T6> void exec_player(Function6<T1, T2, T3, T4, T5, T6, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function6<T1, T2, T3, T4, T5, T6, Boolean>>(this.get_command(), f, this::require_player, i -> i == 0));
    }

    default public <T1> void exec(Consumer1<T1> f) {
        this.add_param(new SentinelExecutorParam<Consumer1<T1>>(this.get_command(), f));
    }

    default public <T1, T2> void exec(Consumer2<T1, T2> f) {
        this.add_param(new SentinelExecutorParam<Consumer2<T1, T2>>(this.get_command(), f));
    }

    default public <T1, T2, T3> void exec(Consumer3<T1, T2, T3> f) {
        this.add_param(new SentinelExecutorParam<Consumer3<T1, T2, T3>>(this.get_command(), f));
    }

    default public <T1, T2, T3, T4> void exec(Consumer4<T1, T2, T3, T4> f) {
        this.add_param(new SentinelExecutorParam<Consumer4<T1, T2, T3, T4>>(this.get_command(), f));
    }

    default public <T1, T2, T3, T4, T5> void exec(Consumer5<T1, T2, T3, T4, T5> f) {
        this.add_param(new SentinelExecutorParam<Consumer5<T1, T2, T3, T4, T5>>(this.get_command(), f));
    }

    default public <T1, T2, T3, T4, T5, T6> void exec(Consumer6<T1, T2, T3, T4, T5, T6> f) {
        this.add_param(new SentinelExecutorParam<Consumer6<T1, T2, T3, T4, T5, T6>>(this.get_command(), f));
    }

    default public <T1> void exec(Function1<T1, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function1<T1, Boolean>>(this.get_command(), f));
    }

    default public <T1, T2> void exec(Function2<T1, T2, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function2<T1, T2, Boolean>>(this.get_command(), f));
    }

    default public <T1, T2, T3> void exec(Function3<T1, T2, T3, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function3<T1, T2, T3, Boolean>>(this.get_command(), f));
    }

    default public <T1, T2, T3, T4> void exec(Function4<T1, T2, T3, T4, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function4<T1, T2, T3, T4, Boolean>>(this.get_command(), f));
    }

    default public <T1, T2, T3, T4, T5> void exec(Function5<T1, T2, T3, T4, T5, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function5<T1, T2, T3, T4, T5, Boolean>>(this.get_command(), f));
    }

    default public <T1, T2, T3, T4, T5, T6> void exec(Function6<T1, T2, T3, T4, T5, T6, Boolean> f) {
        this.add_param(new SentinelExecutorParam<Function6<T1, T2, T3, T4, T5, T6, Boolean>>(this.get_command(), f));
    }

    default public Param any_string() {
        return this.any("string", str -> str);
    }

    default public <T> AnyParam<? extends T> any(String argument_type, Function1<String, ? extends T> from_string) {
        AnyParam<? extends T> p = new AnyParam<T>(this.get_command(), argument_type, from_string);
        this.add_param(p);
        return p;
    }

    default public FixedParam<String> fixed(String fixed) {
        return this.fixed(fixed, str -> str);
    }

    default public <T> FixedParam<T> fixed(T fixed, Function1<T, String> to_string) {
        FixedParam<T> p = new FixedParam<T>(this.get_command(), fixed, to_string);
        this.add_param(p);
        return p;
    }

    default public Param choice(Collection<String> choices) {
        return this.choice("choice", choices, str -> str);
    }

    default public <T> ChoiceParam<T> choice(String argument_type, Collection<? extends T> choices, Function1<T, String> to_string) {
        ChoiceParam<? extends T> p = new ChoiceParam<T>(this.get_command(), argument_type, choices, to_string);
        this.add_param(p);
        return p;
    }

    default public <T> DynamicChoiceParam<T> choice(String argument_type, Function1<CommandSender, Collection<? extends T>> choices, Function2<CommandSender, T, String> to_string, Function2<CommandSender, String, ? extends T> from_string) {
        DynamicChoiceParam<? extends T> p = new DynamicChoiceParam<T>(this.get_command(), argument_type, choices, to_string, from_string);
        this.add_param(p);
        return p;
    }

    default public DynamicChoiceParam<Module<?>> choose_module() {
        return this.choice("module", sender -> ((Module)this.get_command().get_module()).core.get_modules(), (sender, m) -> m.get_name(), (sender, str) -> ((Module)this.get_command().get_module()).core.get_modules().stream().filter(k -> k.get_name().equalsIgnoreCase((String)str)).findFirst().orElse(null));
    }

    default public DynamicChoiceParam<World> choose_world() {
        return this.choice("world", sender -> this.get_command().get_module().getServer().getWorlds(), (sender, w) -> w.getName().toLowerCase(), (sender, str) -> this.get_command().get_module().getServer().getWorlds().stream().filter(w -> w.getName().equalsIgnoreCase((String)str)).findFirst().orElse(null));
    }

    default public DynamicChoiceParam<OfflinePlayer> choose_any_player() {
        return this.choice("any_player", sender -> ((Module)this.get_command().get_module()).get_offline_players_with_valid_name(), (sender, p) -> p.getName(), (sender, str) -> ((Module)this.get_command().get_module()).get_offline_players_with_valid_name().stream().filter(k -> k.getName().equalsIgnoreCase((String)str)).findFirst().orElse(null));
    }

    default public DynamicChoiceParam<Player> choose_online_player() {
        return this.choice("online_player", sender -> this.get_command().get_module().getServer().getOnlinePlayers(), (sender, p) -> p.getName(), (sender, str) -> this.get_command().get_module().getServer().getOnlinePlayers().stream().filter(k -> k.getName().equalsIgnoreCase((String)str)).findFirst().orElse(null));
    }

    default public DynamicChoiceParam<Permission> choose_permission() {
        return this.choice("permission", sender -> this.get_command().get_module().getServer().getPluginManager().getPermissions(), (sender, p) -> p.getName(), (sender, str) -> this.get_command().get_module().getServer().getPluginManager().getPermission(str));
    }

    default public ChoiceParam<GameMode> choose_gamemode() {
        return this.choice("gamemode", List.of(GameMode.values()), m -> m.name().toLowerCase()).ignore_case();
    }

    default public DynamicChoiceParam<Enchantment> choose_enchantment() {
        return this.choose_enchantment((sender, e) -> true);
    }

    default public DynamicChoiceParam<Enchantment> choose_enchantment(Function2<CommandSender, Enchantment, Boolean> filter) {
        return this.choice("enchantment", sender -> RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).stream().filter(e -> (Boolean)filter.apply((CommandSender)sender, (Enchantment)e)).collect(Collectors.toList()), (sender, e) -> e.getKey().toString(), (sender, str) -> {
            String[] parts = str.split(":");
            if (parts.length != 2) {
                return null;
            }
            Enchantment e = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(StorageUtil.namespaced_key(parts[0], parts[1]));
            if (!((Boolean)filter.apply((CommandSender)sender, e)).booleanValue()) {
                return null;
            }
            return e;
        });
    }

    default public CheckResult check_accept_delegate(CommandSender sender, String[] args, int offset) {
        if (this.get_params().isEmpty()) {
            throw new RuntimeException("Encountered parameter without sentinel! This is a bug.");
        }
        List<CheckResult> results = this.get_params().stream().map(p -> p.check_accept(sender, args, offset + 1)).toList();
        for (CheckResult r2 : results) {
            if (!r2.good()) continue;
            return r2;
        }
        Integer max_depth = results.stream().map(r -> r.depth()).reduce(0, Integer::max);
        List<ErrorCheckResult> errors = results.stream().filter(r -> r.depth() == max_depth.intValue()).map(ErrorCheckResult.class::cast).collect(Collectors.toList());
        if (errors.size() == 1) {
            return (CheckResult)errors.get(0);
        }
        return new CombinedErrorCheckResult(errors);
    }

    default public CheckResult check_accept(CommandSender sender, String[] args, int offset) {
        CheckResult result = this.check_parse(sender, args, offset);
        if (!(result instanceof ParseCheckResult)) {
            return result;
        }
        ParseCheckResult p = (ParseCheckResult)result;
        return this.check_accept_delegate(sender, args, offset).prepend(p.argument_type(), p.parsed(), p.include_param());
    }

    default public List<String> build_completions_delegate(CommandSender sender, String[] args, int offset) {
        if (this.get_params().isEmpty()) {
            throw new RuntimeException("Encountered parameter without sentinel! This is a bug.");
        }
        return this.get_params().stream().map(p -> p.build_completions(sender, args, offset + 1)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public List<String> build_completions(CommandSender sender, String[] args, int offset) {
        if (offset < args.length - 1) {
            if (this.check_parse(sender, args, offset) instanceof ParseCheckResult) {
                return this.build_completions_delegate(sender, args, offset);
            }
            return Collections.emptyList();
        }
        return this.completions_for(sender, args, offset);
    }

    public List<String> completions_for(CommandSender var1, String[] var2, int var3);

    public CheckResult check_parse(CommandSender var1, String[] var2, int var3);

    public Command<?> get_command();
}

