/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.command.argumentType;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class OfflinePlayerArgumentType
implements CustomArgumentType.Converted<OfflinePlayer, String> {
    @NotNull
    public static OfflinePlayerArgumentType offlinePlayer() {
        return new OfflinePlayerArgumentType();
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }

    @NotNull
    public OfflinePlayer convert(@NotNull String nativeType) throws CommandSyntaxException {
        for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
            if (!nativeType.equalsIgnoreCase(p.getName())) continue;
            return p;
        }
        return null;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        Stream<String> stream = Arrays.stream(players).map(p -> p.getName()).filter(p -> p != null);
        if (!builder.getRemaining().isBlank()) {
            stream = stream.filter(player -> player.contains(builder.getRemaining()));
        }
        stream.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

