/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.command.argumentType;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.command.enums.TimeValue;

public class TimeValueArgumentType
implements CustomArgumentType.Converted<TimeValue, String> {
    public static TimeValueArgumentType timeValue() {
        return new TimeValueArgumentType();
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }

    @NotNull
    public TimeValue convert(@NotNull String nativeType) throws CommandSyntaxException {
        return TimeValue.valueOf(nativeType);
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        Stream<String> stream = Arrays.stream(TimeValue.values()).map(time -> time.name());
        if (!builder.getRemaining().isBlank()) {
            stream = stream.filter(timeName -> timeName.contains(builder.getRemaining()));
        }
        stream.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

