/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.command.params;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.command.check.CheckResult;
import org.oddlama.vane.core.command.check.ErrorCheckResult;
import org.oddlama.vane.core.command.check.ParseCheckResult;
import org.oddlama.vane.core.command.params.BaseParam;
import org.oddlama.vane.core.functional.Function1;

public class ChoiceParam<T>
extends BaseParam {
    private String argument_type;
    private Collection<? extends T> choices;
    private Function1<T, String> to_string;
    private HashMap<String, T> from_string = new HashMap();
    private boolean ignore_case = false;

    public ChoiceParam(Command<?> command, String argument_type, Collection<? extends T> choices, Function1<T, String> to_string) {
        super(command);
        this.argument_type = argument_type;
        this.choices = choices;
        this.to_string = to_string;
        for (T c : choices) {
            this.from_string.put(to_string.apply(c), c);
        }
    }

    public ChoiceParam<T> ignore_case() {
        this.ignore_case = true;
        this.from_string.clear();
        for (T c : this.choices) {
            this.from_string.put(this.to_string.apply(c), c);
        }
        return this;
    }

    @Override
    public CheckResult check_parse(CommandSender sender, String[] args, int offset) {
        if (args.length <= offset) {
            return new ErrorCheckResult(offset, "\u00a76missing argument: \u00a73" + this.argument_type + "\u00a7r");
        }
        T parsed = this.parse(args[offset]);
        if (parsed == null) {
            return new ErrorCheckResult(offset, "\u00a76invalid \u00a73" + this.argument_type + "\u00a76: \u00a7b" + args[offset] + "\u00a7r");
        }
        return new ParseCheckResult(offset, this.argument_type, parsed, true);
    }

    @Override
    public List<String> completions_for(CommandSender sender, String[] args, int offset) {
        return this.choices.stream().map(choice -> this.to_string.apply(choice)).filter(str -> str.toLowerCase().contains(args[offset].toLowerCase())).collect(Collectors.toList());
    }

    private T parse(String arg) {
        if (this.ignore_case) {
            return this.from_string.get(arg.toLowerCase());
        }
        return this.from_string.get(arg);
    }
}

