/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.command.params;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.command.check.CheckResult;
import org.oddlama.vane.core.command.check.ErrorCheckResult;
import org.oddlama.vane.core.command.check.ParseCheckResult;
import org.oddlama.vane.core.command.params.BaseParam;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.Function2;

public class DynamicChoiceParam<T>
extends BaseParam {
    private String argument_type;
    private Function1<CommandSender, Collection<? extends T>> choices;
    private Function2<CommandSender, T, String> to_string;
    private Function2<CommandSender, String, ? extends T> from_string;

    public DynamicChoiceParam(Command<?> command, String argument_type, Function1<CommandSender, Collection<? extends T>> choices, Function2<CommandSender, T, String> to_string, Function2<CommandSender, String, ? extends T> from_string) {
        super(command);
        this.argument_type = argument_type;
        this.choices = choices;
        this.to_string = to_string;
        this.from_string = from_string;
    }

    @Override
    public CheckResult check_parse(CommandSender sender, String[] args, int offset) {
        if (args.length <= offset) {
            return new ErrorCheckResult(offset, "\u00a76missing argument: \u00a73" + this.argument_type + "\u00a7r");
        }
        T parsed = this.parse(sender, args[offset]);
        if (parsed == null) {
            return new ErrorCheckResult(offset, "\u00a76invalid \u00a73" + this.argument_type + "\u00a76: \u00a7b" + args[offset] + "\u00a7r");
        }
        return new ParseCheckResult(offset, this.argument_type, parsed, true);
    }

    @Override
    public List<String> completions_for(CommandSender sender, String[] args, int offset) {
        return this.choices.apply(sender).stream().map(choice -> this.to_string.apply(sender, choice)).filter(str -> str.toLowerCase().contains(args[offset].toLowerCase())).collect(Collectors.toList());
    }

    private T parse(CommandSender sender, String arg) {
        return this.from_string.apply(sender, arg);
    }
}

